<?php
function register_review_author_metabox( $manager, $stmDomain ) {

	/*Register sections*/
	$manager->register_section(
		'stm_author_details',
		array(
			'label' => esc_html__( 'Author', 'stm_motors_review' ),
			'icon'  => 'fa fa-bookmark',
		)
	);

	/*Register controls*/
	$fields = array(
		'review_author_name'   => array(
			'label'    => esc_html__( 'Author name', 'stm_motors_review' ),
			'section'  => 'stm_author_details',
			'validate' => 'stm_motors_review_no_validate',
		),
		'review_author_desc'   => array(
			'label'    => esc_html__( 'Author excerpt', 'stm_motors_review' ),
			'section'  => 'stm_author_details',
			'validate' => 'stm_motors_review_no_validate',
		),
		'review_author_avatar' => array(
			'type'     => 'image',
			'label'    => esc_html__( 'Author photo', 'stm_motors_review' ),
			'section'  => 'stm_author_details',
			'size'     => 'thumbnail',
			'validate' => 'stm_motors_review_validate_image',
		),
	);

	$fields = apply_filters( 'stm_review_title_fields', $fields );

	foreach ( $fields as $field => $field_info ) {
		/*Register control*/
		$type     = ( ! empty( $field_info['type'] ) ) ? $field_info['type'] : 'text';
		$validate = ( ! empty( $field_info['validate'] ) ) ? $field_info['validate'] : 'stm_motors_review_no_validate';
		$manager->register_control(
			$field,
			array(
				'type'    => $type,
				'section' => $field_info['section'],
				'label'   => $field_info['label'],
				'attr'    => array(
					'class' => 'widefat',
				),
			)
		);

		/*Register setting*/
		$manager->register_setting(
			$field,
			array(
				'sanitize_callback' => $validate,
			)
		);
	}
}

