<?php

namespace MotorsVehiclesListing\Addons;

class ProFeatures {
	public static function list() {
		return array(
			'inventory_skins'         => array(
				'name'          => esc_html__( 'Inventory Skins', 'stm_vehicles_listing' ),
				'url'           => esc_url( STM_LISTINGS_URL . '/assets/pro-features/img/InventorySkins.png' ),
				'settings'      => admin_url( 'admin.php?page=mvl_search_and_filter_settings' ),
				'description'   => esc_html__( 'Give your inventory pages a fresh look with multiple ready-to-use skins. Easily switch layouts to match your dealership style.', 'stm_vehicles_listing' ),
				'pro_url'       => 'https://stylemixthemes.com/car-dealer-plugin/pricing/?utm_source=motorswpadmin&utm_campaign=motors-plugin&licenses=1&billing_cycle=annual',
				'documentation' => 'https://docs.stylemixthemes.com/motors-car-dealer-classifieds-and-listing/search-filter/search-filters#inventory-page-skins',
				'img_url'       => 'inventory-skins',
				'toggle'        => false,
			),
			'keyword-search'          => array(
				'name'          => esc_html__( 'Keyword Search', 'stm_vehicles_listing' ),
				'url'           => esc_url( STM_LISTINGS_URL . '/assets/pro-features/img/KeywordSearch.png' ),
				'settings'      => admin_url( 'admin.php?page=mvl_search_and_filter_settings' ),
				'description'   => esc_html__( 'Enable quick keyword search so visitors can instantly find listings by typing model, brand, or other keywords.', 'stm_vehicles_listing' ),
				'pro_url'       => 'https://stylemixthemes.com/car-dealer-plugin/pricing/?utm_source=motorswpadmin&utm_campaign=motors-plugin&licenses=1&billing_cycle=annual',
				'documentation' => 'https://docs.stylemixthemes.com/motors-car-dealer-classifieds-and-listing/search-filter/search-filters#search-by-keywords-pro-feature',
				'img_url'       => 'keyword-search',
				'toggle'        => false,
			),
			'filter-by-location'      => array(
				'name'          => esc_html__( 'Filter by Location', 'stm_vehicles_listing' ),
				'url'           => esc_url( STM_LISTINGS_URL . '/assets/pro-features/img/FilterByLocation.png' ),
				'settings'      => admin_url( 'admin.php?page=mvl_search_and_filter_settings' ),
				'description'   => esc_html__( 'Add a location filter so users can search cars by city, state, or distance, making browsing more convenient.', 'stm_vehicles_listing' ),
				'pro_url'       => 'https://stylemixthemes.com/car-dealer-plugin/pricing/?utm_source=motorswpadmin&utm_campaign=motors-plugin&licenses=1&billing_cycle=annual',
				'documentation' => 'https://docs.stylemixthemes.com/motors-car-dealer-classifieds-and-listing/search-filter/search-filters#filter-by-location-pro-feature',
				'img_url'       => 'filter-by-location',
				'toggle'        => false,
			),
			'custom-fields-types'     => array(
				'name'          => esc_html__( 'Custom Fields Types', 'stm_vehicles_listing' ),
				'url'           => esc_url( STM_LISTINGS_URL . '/assets/pro-features/img/CustomFieldsTypes.png' ),
				'settings'      => admin_url( 'admin.php?page=listing_categories' ),
				'description'   => esc_html__( 'Expand your custom fields with advanced types (checkboxes, dropdowns, ranges) to better capture listing details.', 'stm_vehicles_listing' ),
				'pro_url'       => 'https://stylemixthemes.com/car-dealer-plugin/pricing/?utm_source=motorswpadmin&utm_campaign=motors-plugin&licenses=1&billing_cycle=annual',
				'documentation' => 'https://docs.stylemixthemes.com/motors-car-dealer-classifieds-and-listing/search-filter/custom-fields',
				'img_url'       => 'custom-fields-types',
				'toggle'        => false,
			),
			'listing-card-skins'      => array(
				'name'          => esc_html__( 'Listing Card Skins', 'stm_vehicles_listing' ),
				'url'           => esc_url( STM_LISTINGS_URL . '/assets/pro-features/img/ListingCardSkins.png' ),
				'settings'      => admin_url( 'admin.php?page=mvl_search_results_settings&submenu=listing-info-card#listing_settings' ),
				'description'   => esc_html__( 'Showcase listings with different card styles. Choose the look that best fits your inventory presentation.', 'stm_vehicles_listing' ),
				'pro_url'       => 'https://stylemixthemes.com/car-dealer-plugin/pricing/?utm_source=motorswpadmin&utm_campaign=motors-plugin&licenses=1&billing_cycle=annual',
				'documentation' => 'https://docs.stylemixthemes.com/motors-car-dealer-classifieds-and-listing/search-filter/search-results-page/listing-info-card#info-card-skins',
				'img_url'       => 'listing-card-skins',
				'toggle'        => false,
			),
			'listing-templates'       => array(
				'name'          => esc_html__( 'Listing Templates', 'stm_vehicles_listing' ),
				'url'           => esc_url( STM_LISTINGS_URL . '/assets/pro-features/img/ListingTemplates.png' ),
				'settings'      => admin_url( 'admin.php?page=mvl_single_listing_template_settings' ),
				'description'   => esc_html__( 'Use ready-made templates to create professional-looking listing pages quickly.', 'stm_vehicles_listing' ),
				'pro_url'       => 'https://stylemixthemes.com/car-dealer-plugin/pricing/?utm_source=motorswpadmin&utm_campaign=motors-plugin&licenses=1&billing_cycle=annual',
				'documentation' => 'https://docs.stylemixthemes.com/motors-car-dealer-classifieds-and-listing/single-listing/listing-templates',
				'img_url'       => 'listing-templates',
				'toggle'        => false,
			),
			'whatsapp-integration'    => array(
				'name'          => esc_html__( 'WhatsApp Integration', 'stm_vehicles_listing' ),
				'url'           => esc_url( STM_LISTINGS_URL . '/assets/pro-features/img/WhatsappIntegration.png' ),
				'settings'      => admin_url( 'admin.php?page=mvl_listing_details_settings&submenu=page-layout#single_listing' ),
				'description'   => esc_html__( 'Allow buyers to contact dealers instantly via WhatsApp directly from the listing page.', 'stm_vehicles_listing' ),
				'pro_url'       => 'https://stylemixthemes.com/car-dealer-plugin/pricing/?utm_source=motorswpadmin&utm_campaign=motors-plugin&licenses=1&billing_cycle=annual',
				'documentation' => 'https://docs.stylemixthemes.com/motors-car-dealer-classifieds-and-listing/single-listing/listing-page-details/page-layout#whatsapp-contact-button-pro-feature',
				'img_url'       => 'whatsapp-integration',
				'toggle'        => false,
			),
			'loan-calculator'         => array(
				'name'          => esc_html__( 'Loan Calculator', 'stm_vehicles_listing' ),
				'url'           => esc_url( STM_LISTINGS_URL . '/assets/pro-features/img/LoanCalculator.png' ),
				'settings'      => admin_url( 'admin.php?page=mvl_listing_details_settings&submenu=page-layout#single_listing' ),
				'description'   => esc_html__( 'Let visitors calculate monthly payments directly on the listing page, improving lead quality.', 'stm_vehicles_listing' ),
				'pro_url'       => 'https://stylemixthemes.com/car-dealer-plugin/pricing/?utm_source=motorswpadmin&utm_campaign=motors-plugin&licenses=1&billing_cycle=annual',
				'documentation' => 'https://docs.stylemixthemes.com/motors-car-dealer-classifieds-and-listing/single-listing/listing-page-details/loan-calculator-pro-feature',
				'img_url'       => 'loan-calculator',
				'toggle'        => false,
			),
			'seo-friendly-url'        => array(
				'name'          => esc_html__( 'SEO Friendly URL', 'stm_vehicles_listing' ),
				'url'           => esc_url( STM_LISTINGS_URL . '/assets/pro-features/img/SeoFriendly.png' ),
				'settings'      => admin_url( 'admin.php?page=mvl_search_results_settings' ),
				'description'   => esc_html__( 'Improve your search engine ranking with clean, SEO-optimized URLs for all listings.', 'stm_vehicles_listing' ),
				'pro_url'       => 'https://stylemixthemes.com/car-dealer-plugin/pricing/?utm_source=motorswpadmin&utm_campaign=motors-plugin&licenses=1&billing_cycle=annual',
				'documentation' => 'https://docs.stylemixthemes.com/motors-car-dealer-classifieds-and-listing/search-filter/search-results-page/general#seo-friendly-url-pro-feature',
				'img_url'       => 'seo-friendly-url',
				'toggle'        => false,
			),
			'image-sliding-on-hover'  => array(
				'name'          => esc_html__( 'Image Sliding on Hover', 'stm_vehicles_listing' ),
				'url'           => esc_url( STM_LISTINGS_URL . '/assets/pro-features/img/ImageSlidingOnHover.png' ),
				'settings'      => admin_url( 'admin.php?page=mvl_search_results_settings' ),
				'description'   => esc_html__( 'Enhance user experience with smooth image sliding when hovering over listing cards.', 'stm_vehicles_listing' ),
				'pro_url'       => 'https://stylemixthemes.com/car-dealer-plugin/pricing/?utm_source=motorswpadmin&utm_campaign=motors-plugin&licenses=1&billing_cycle=annual',
				'documentation' => 'https://docs.stylemixthemes.com/motors-car-dealer-classifieds-and-listing/search-filter/search-results-page/general#image-sliding-on-hover-pro-feature',
				'img_url'       => 'image-sliding-on-hover',
				'toggle'        => false,
			),
			'sold-status'             => array(
				'name'          => esc_html__( 'Sold Status For Listings', 'stm_vehicles_listing' ),
				'url'           => esc_url( STM_LISTINGS_URL . '/assets/pro-features/img/SoldStatus.png' ),
				'settings'      => admin_url( 'admin.php?page=mvl_search_results_settings' ),
				'description'   => esc_html__( 'Mark listings as "Sold" to keep your site updated and build customer trust.', 'stm_vehicles_listing' ),
				'pro_url'       => 'https://stylemixthemes.com/car-dealer-plugin/pricing/?utm_source=motorswpadmin&utm_campaign=motors-plugin&licenses=1&billing_cycle=annual',
				'documentation' => 'https://docs.stylemixthemes.com/motors-car-dealer-classifieds-and-listing/search-filter/search-results-page/general#sold-status-for-vehicles-pro-feature',
				'img_url'       => 'sold-status',
				'toggle'        => false,
			),
			'multiple-currencies'     => array(
				'name'          => esc_html__( 'Multiple Currencies', 'stm_vehicles_listing' ),
				'url'           => esc_url( STM_LISTINGS_URL . '/assets/pro-features/img/MultipleCurrencies.png' ),
				'settings'      => admin_url( 'admin.php?page=mvl_search_results_settings&submenu=currency#listing_settings' ),
				'description'   => esc_html__( 'Support multiple currencies on your site, allowing buyers from different regions to view prices comfortably.', 'stm_vehicles_listing' ),
				'pro_url'       => 'https://stylemixthemes.com/car-dealer-plugin/pricing/?utm_source=motorswpadmin&utm_campaign=motors-plugin&licenses=1&billing_cycle=annual',
				'documentation' => 'https://docs.stylemixthemes.com/motors-car-dealer-classifieds-and-listing/search-filter/search-results-page/currency',
				'img_url'       => 'multiple-currencies',
				'toggle'        => false,
			),
			'dealer-role'             => array(
				'name'          => esc_html__( 'Dealer Role', 'stm_vehicles_listing' ),
				'url'           => esc_url( STM_LISTINGS_URL . '/assets/pro-features/img/DealerRole.png' ),
				'settings'      => admin_url( 'admin.php?page=mvl_plugin_settings&submenu=dealer#profile' ),
				'description'   => esc_html__( 'Enable dealer accounts with special permissions to add, edit, and manage their own listings.', 'stm_vehicles_listing' ),
				'pro_url'       => 'https://stylemixthemes.com/car-dealer-plugin/pricing/?utm_source=motorswpadmin&utm_campaign=motors-plugin&licenses=1&billing_cycle=annual',
				'documentation' => 'https://docs.stylemixthemes.com/motors-car-dealer-classifieds-and-listing/motors-plugin-settings/profile/dealer-pro-feature',
				'img_url'       => 'dealer-role',
				'toggle'        => false,
			),
			'google-maps'             => array(
				'name'          => esc_html__( 'Google Maps', 'stm_vehicles_listing' ),
				'url'           => esc_url( STM_LISTINGS_URL . '/assets/pro-features/img/GoogleMaps.png' ),
				'settings'      => admin_url( 'admin.php?page=mvl_plugin_settings&submenu=google-maps#google_services_tab' ),
				'description'   => esc_html__( 'Integrate Google Maps to display vehicle locations and improve search by proximity.', 'stm_vehicles_listing' ),
				'pro_url'       => 'https://stylemixthemes.com/car-dealer-plugin/pricing/?utm_source=motorswpadmin&utm_campaign=motors-plugin&licenses=1&billing_cycle=annual',
				'documentation' => 'https://docs.stylemixthemes.com/motors-car-dealer-classifieds-and-listing/motors-plugin-settings/google-services/google-maps-pro-feature',
				'img_url'       => 'google-maps',
				'toggle'        => false,
			),
			'paid-featured-listings'  => array(
				'name'          => esc_html__( 'Paid Featured Listings', 'stm_vehicles_listing' ),
				'url'           => esc_url( STM_LISTINGS_URL . '/assets/pro-features/img/PaidFeaturedListings.png' ),
				'settings'      => admin_url( 'admin.php?page=mvl_plugin_settings&submenu=monetization#monetization' ),
				'description'   => esc_html__( 'Allow sellers to pay for featuring their listings at the top of search results.(Motors Plugin > Settings > Monetization)', 'stm_vehicles_listing' ),
				'pro_url'       => 'https://stylemixthemes.com/car-dealer-plugin/pricing/?utm_source=motorswpadmin&utm_campaign=motors-plugin&licenses=1&billing_cycle=annual',
				'documentation' => 'https://docs.stylemixthemes.com/motors-car-dealer-classifieds-and-listing/motors-plugin-settings/monetization-pro-feature',
				'img_url'       => 'paid-featured-listings',
				'toggle'        => false,
			),
			'pay-per-submit'          => array(
				'name'          => esc_html__( 'Pay Per Submit', 'stm_vehicles_listing' ),
				'url'           => esc_url( STM_LISTINGS_URL . '/assets/pro-features/img/PayPerSubmit.png' ),
				'settings'      => admin_url( 'admin.php?page=mvl_plugin_settings&submenu=monetization#monetization' ),
				'description'   => esc_html__( 'Charge users per listing submission, turning your site into a marketplace.', 'stm_vehicles_listing' ),
				'pro_url'       => 'https://stylemixthemes.com/car-dealer-plugin/pricing/?utm_source=motorswpadmin&utm_campaign=motors-plugin&licenses=1&billing_cycle=annual',
				'documentation' => 'https://docs.stylemixthemes.com/motors-car-dealer-classifieds-and-listing/motors-plugin-settings/monetization-pro-feature',
				'img_url'       => 'pay-per-submit',
				'toggle'        => false,
			),
			'sell-a-listing-online'   => array(
				'name'          => esc_html__( 'Sell A Listing Online', 'stm_vehicles_listing' ),
				'url'           => esc_url( STM_LISTINGS_URL . '/assets/pro-features/img/SellListingOnline.png' ),
				'settings'      => admin_url( 'admin.php?page=mvl_plugin_settings&submenu=monetization#monetization' ),
				'description'   => esc_html__( 'Enable online selling directly through your site, simplifying transactions for buyers and sellers.', 'stm_vehicles_listing' ),
				'pro_url'       => 'https://stylemixthemes.com/car-dealer-plugin/pricing/?utm_source=motorswpadmin&utm_campaign=motors-plugin&licenses=1&billing_cycle=annual',
				'documentation' => 'https://docs.stylemixthemes.com/motors-car-dealer-classifieds-and-listing/motors-plugin-settings/monetization-pro-feature',
				'img_url'       => 'sell-a-listing-online',
				'toggle'        => false,
			),
			'email-templates-manager' => array(
				'name'          => esc_html__( 'Email Templates Manager', 'stm_vehicles_listing' ),
				'url'           => esc_url( STM_LISTINGS_URL . '/assets/pro-features/img/EmailTemplatesManager.png' ),
				'settings'      => admin_url( 'admin.php?page=email-template-manager' ),
				'description'   => esc_html__( 'Customize all your email notifications with a drag-and-drop email template builder.', 'stm_vehicles_listing' ),
				'pro_url'       => 'https://stylemixthemes.com/car-dealer-plugin/pricing/?utm_source=motorswpadmin&utm_campaign=motors-plugin&licenses=1&billing_cycle=annual',
				'documentation' => 'https://docs.stylemixthemes.com/motors-car-dealer-classifieds-and-listing/additional-features/email-template-manager',
				'img_url'       => 'email-templates-manager',
				'toggle'        => false,
			),
		);
	}
}
