<?php
add_action(
	'plugins_loaded',
	function () {
		$types = get_option( 'stm_motors_listing_types', array() );

		if ( ! get_option( 'multilisting_title_frontend_patched' ) && ! empty( $types ) ) {
			foreach ( $types['multilisting_repeater'] as $type_settings ) {
				$slug = $type_settings['slug'];
				$opts = multilisting_get_type_taxonomies( $slug, true );

				if ( ! empty( $types[ $slug . '_listing_directory_title_frontend' ] ) && is_string( $types[ $slug . '_listing_directory_title_frontend' ] ) ) {
					$selected_tax     = explode( ' ', $types[ $slug . '_listing_directory_title_frontend' ] );
					$new_selected_tax = array();

					foreach ( $selected_tax as $tax ) {
						$tax = str_replace( array( '{', '}' ), '', $tax );
						if ( ! empty( $opts[ $tax ] ) ) {
							$new_selected_tax[] = $opts[ $tax ];
						}
					}

					$types[ $slug . '_listing_directory_title_frontend' ] = $new_selected_tax;
				}
			}

			update_option( 'stm_motors_listing_types', $types );
			add_option( 'multilisting_title_frontend_patched', true );
		}
	}
);

// register listing types nuxy page
add_filter(
	'wpcfto_options_page_setup',
	function ( $setups ) {
		$pages = multilisting_get_all_pages();

		$setups[] = array(
			'option_name' => 'stm_motors_listing_types',
			'title'       => esc_html__( 'Listing Types', 'motors_listing_types' ),
			'sub_title'   => esc_html__( 'by StylemixThemes', 'motors_listing_types' ),
			'logo'        => get_template_directory_uri() . '/assets/admin/images/logo.png',
			'page'        => array(
				'page_title' => esc_html__( 'Motors Listing Types', 'motors_listing_types' ),
				'menu_title' => esc_html__( 'Listing Types', 'motors_listing_types' ),
				'menu_slug'  => 'stm_motors_listing_types',
				'icon'       => get_template_directory_uri() . '/assets/admin/images/icon.png',
				'position'   => 5,
			),
			'fields'      => array(
				'listing_types' => array(
					'name'   => esc_html__( 'Listing Types', 'motors_listing_types' ),
					'icon'   => 'fas fa-cubes',
					'fields' => array(
						'multilisting_repeater' => array(
							'type'        => 'repeater',
							'label'       => esc_html__( 'Listing Type', 'motors_listing_types' ),
							'load_labels' => array(
								'add_label' => esc_html__( 'Add Listing Type', 'motors_listing_types' ),
							),
							'fields'      => array(
								'label'          => array(
									'type'  => 'text',
									'label' => esc_html__( 'Name', 'motors_listing_types' ),
								),
								'slug'           => array(
									'type'        => 'text',
									'label'       => esc_html__( 'Slug', 'motors_listing_types' ),
									'description' => esc_html__( 'The URL-friendly version of the name. Accepts only letters, numbers, and hyphens (Max 19 characters)', 'motors_listing_types' ),
								),
								'inventory_page' => array(
									'type'    => 'select',
									'label'   => esc_html__( 'Inventory Page', 'motors_listing_types' ),
									'options' => $pages,
								),
								'add_page'       => array(
									'type'    => 'select',
									'label'   => esc_html__( 'Add Listing Page', 'motors_listing_types' ),
									'options' => $pages,
								),
								'icon'           => array(
									'type'  => 'icon_picker',
									'label' => esc_html__( 'Icon', 'motors_listing_types' ),
								),
							),
						),
						'multilisting_current_motors_layout' => array(
							'type'  => 'text',
							'label' => esc_html__( 'Current Motors Layout', 'motors_listing_types' ),
							'value' => multilisting_get_current_motors_layout(),
						),
					),
				),
			),
		);

		// check for existing listing types and add settings for each listing type
		$options = get_option( 'stm_motors_listing_types' );

		if ( ! empty( $options['multilisting_repeater'] ) ) {
			foreach ( $options['multilisting_repeater'] as $key => $item ) {

				if ( empty( $item['label'] ) || empty( $item['slug'] ) ) {
					continue;
				}

				$icon  = ( $item['icon']['icon'] ) ? $item['icon']['icon'] : 'fas fa-car-alt';
				$confs = array_merge( multilisting_get_inventory_confs( $item['slug'] ), multilisting_get_single_confs( $item['slug'] ), multilisting_get_add_listing_confs( $item['slug'] ), multilisting_get_features_confs( $item['slug'] ) );

				$arr_key = array_search( 'stm_motors_listing_types', array_column( $setups, 'option_name' ), true );

				if ( false !== $arr_key ) {
					$setups[ $arr_key ]['fields'][ $item['slug'] ]['name']   = $item['label'];
					$setups[ $arr_key ]['fields'][ $item['slug'] ]['icon']   = $icon;
					$setups[ $arr_key ]['fields'][ $item['slug'] ]['fields'] = $confs;
				}
			}
		}

		return $setups;
	}
);

function multilisting_get_all_pages() {
	// pages to assign
	$pages     = array();
	$get_pages = get_posts(
		array(
			'post_type'      => 'page',
			'posts_per_page' => - 1,
			'post_status'    => 'publish',
		)
	);

	if ( ! empty( $get_pages ) ) {
		foreach ( $get_pages as $page ) {
			$pages[ $page->ID ] = $page->post_title;
		}
	}

	return $pages;
}

function multilisting_get_current_motors_layout() {
	$layout = get_option( 'stm_motors_chosen_template' );

	if ( empty( $layout ) ) {
		$layout = 'car_dealer';
	}

	return $layout;
}

function stm_multilisting_sort_options( $slug ) {
	$opts = (array) get_option( "stm_{$slug}_options", array() );

	$options = array();

	if ( ! empty( $opts ) ) {
		foreach ( $opts as $tax ) {
			if ( isset( $tax['numeric'] ) && ! empty( $tax['numeric'] ) ) {
				if ( true === apply_filters( 'stm_is_listing_price_field', $tax['slug'] ) ) {
					$options['price'] = $tax['single_name'];
				} else {
					$options[ $tax['slug'] ] = $tax['single_name'];
				}
			}
		}
	}

	return $options;
}

function multilisting_default_sortby( $slug ) {
	$sorts = array(
		'date_high' => esc_html__( 'Date: newest first', 'motors_listing_types' ),
		'date_low'  => esc_html__( 'Date: oldest first', 'motors_listing_types' ),
	);

	$options = stm_multilisting_sort_options( $slug );
	if ( ! empty( $options ) ) {
		foreach ( $options as $slug => $name ) {
			$sorts[ $slug . '_high' ] = sprintf( esc_html__( '%s: highest first', 'motors_listing_types' ), $name );
			$sorts[ $slug . '_low' ]  = sprintf( esc_html__( '%s: lowest first', 'motors_listing_types' ), $name );
		}
	}

	return $sorts;

}

function multilisting_get_inventory_confs( $slug ) {
	$inventory_settings = array();
	$cfto_sidebars      = array();
	$cfto_positions     = array();

	if ( function_exists( 'stm_me_wpcfto_sidebars' ) ) {
		$cfto_sidebars = stm_me_wpcfto_sidebars();
	}

	if ( function_exists( 'stm_me_wpcfto_positions' ) ) {
		$cfto_positions = stm_me_wpcfto_positions();
	}

	$conf = array(
		$slug . '_inventory_custom_settings'            => array(
			'type'        => 'checkbox',
			'label'       => esc_html__( 'Custom Inventory Settings', 'motors_listing_types' ),
			'submenu'     => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'value'       => false,
			'description' => esc_html__( 'Ignores global Inventory Settings in Motors Plugin Settings', 'motors_listing_types' ),
		),
		$slug . '_classic_listing_title'                => array(
			'label'        => esc_html__( 'Listing Archive "Title Box" Title', 'motors_listing_types' ),
			'type'         => 'text',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'value'        => '',
			'dependencies' => '&&',
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'aircrafts||boats||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||motorcycle',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_hide_price_labels'                    => array(
			'label'        => esc_html__( 'Hide Price Labels on Listing Archive', 'motors_listing_types' ),
			'type'         => 'checkbox',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'aircrafts||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_listing_directory_title_default'      => array(
			'label'        => esc_html__( 'Default Title', 'motors_listing_types' ),
			'type'         => 'text',
			'value'        => '',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'aircrafts||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||motorcycle',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_listing_sidebar'                      => array(
			'label'        => esc_html__( 'Inventory Sidebar', 'motors_listing_types' ),
			'type'         => 'select',
			'options'      => $cfto_sidebars,
			'value'        => 'no_sidebar',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'ev_dealer||aircrafts||boats||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||motorcycle',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_listing_view_type'                    => array(
			'label'        => esc_html__( 'Listing View Type', 'motors_listing_types' ),
			'type'         => 'radio',
			'options'      =>
				array(
					'grid' => 'Grid',
					'list' => 'List',
				),
			'value'        => 'list',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'ev_dealer||aircrafts||boats||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||motorcycle',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_listing_view_type_mobile'             => array(
			'label'        => esc_html__( 'Mobile Listing View Type', 'motors_listing_types' ),
			'type'         => 'radio',
			'options'      =>
				array(
					'grid' => 'Grid',
					'list' => 'List',
				),
			'value'        => 'grid',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'ev_dealer||aircrafts||boats||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||motorcycle',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_grid_title_max_length'                => array(
			'label'        => esc_html__( 'Grid Item Title Max Length', 'motors_listing_types' ),
			'type'         => 'text',
			'value'        => '44',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'   => $slug . '_listing_view_type',
					'value' => 'grid',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_enable_features_search'               => array(
			'label'        => esc_html__( 'Display Additional Features on Inventory Filter', 'motors_listing_types' ),
			'type'         => 'checkbox',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'ev_dealer||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||motorcycle',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_enable_favorite_items'                => array(
			'label'        => esc_html__( 'Enable Favorite Button', 'motors_listing_types' ),
			'type'         => 'checkbox',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_multilisting_sort_options'            => array(
			'label'        => esc_html__( 'Sort Options', 'motors_listing_types' ),
			'type'         => 'multi_checkbox',
			'options'      => stm_multilisting_sort_options( $slug ),
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'ev_dealer||aircrafts||boats||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||motorcycle',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_multilisting_default_sort_by'         => array(
			'label'        => esc_html__( 'Default Sort Option', 'motors_listing_types' ),
			'type'         => 'select',
			'value'        => 'date_high',
			'options'      => multilisting_default_sortby( $slug ),
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'description'  => esc_html__( 'Default option must be selected above', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'ev_dealer||aircrafts||boats||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||motorcycle',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_listing_filter_position'              => array(
			'label'        => esc_html__( 'Filter Position', 'motors_listing_types' ),
			'type'         => 'select',
			'value'        => 'left',
			'options'      => $cfto_positions,
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'ev_dealer||aircrafts||boats||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||motorcycle',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_enable_location'                      => array(
			'label'        => esc_html__( 'Show Location/Include Location in Filter', 'motors_listing_types' ),
			'type'         => 'checkbox',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'ev_dealer||boats||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_enable_distance_search'               => array(
			'label'        => esc_html__( 'Enable distance search', 'motors_listing_types' ),
			'type'         => 'checkbox',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_enable_location',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'ev_dealer||boats||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
					'section' => 'listing_types',
				),
			),
			'value'        => true,
			'dependencies' => '&&',
		),
		$slug . '_recommend_items_empty_result'         => array(
			'label'        => esc_html__( 'Recommend items in other locations in case of empty result', 'motors_listing_types' ),
			'type'         => 'checkbox',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_enable_location',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'motorcycle||ev_dealer||boats||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
					'section' => 'listing_types',
				),
			),
			'value'        => true,
			'dependencies' => '&&',
		),
		$slug . '_distance_measure_unit'                => array(
			'label'        => esc_html__( 'Unit Measurement', 'motors_listing_types' ),
			'type'         => 'select',
			'options'      =>
				array(
					'miles'      => 'Miles',
					'kilometers' => 'Kilometers',
				),
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'   => $slug . '_enable_location',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'motorcycle||ev_dealer||boats||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_distance_search'                      => array(
			'label'        => esc_html__( 'Set Max Search Radius', 'motors_listing_types' ),
			'type'         => 'text',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'   => $slug . '_enable_location',
					'value' => 'not_empty',
				),
				array(
					'key'   => $slug . '_enable_distance_search',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'ev_dealer||boats||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_listing_directory_title_frontend'     => array(
			'label'       => esc_html__( 'Display Generated Listing Title as:', 'motors_listing_types' ),
			'type'        => 'multiselect',
			'options'     => multilisting_get_type_taxonomies( $slug ),
			'description' => sprintf( __( 'The title will be generated based on the %s categories.', 'motors_listing_types' ), $slug ),
			//phpcs:ignore
			'submenu'     => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'  => array(
				'key'   => $slug . '_inventory_custom_settings',
				'value' => 'not_empty',
			),
		),
		$slug . '_show_generated_title_as_label'        => array(
			'label'        => esc_html__( 'Show Two First Parameters as a Badge', 'motors_listing_types' ),
			'type'         => 'checkbox',
			'description'  => 'Archive Page and Single Listing',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'   => $slug . '_listing_view_type',
					'value' => 'list',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'ev_dealer||aircrafts||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||motorcycle',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_listing_directory_enable_dealer_info' => array(
			'label'        => esc_html__( 'Enable Dealer Info on Listing', 'motors_listing_types' ),
			'type'         => 'checkbox',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'   => $slug . '_listing_view_type',
					'value' => 'list',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||aircrafts',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_show_listing_stock'                   => array(
			'label'        => esc_html__( 'Show Stock', 'motors_listing_types' ),
			'type'         => 'checkbox',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'   => $slug . '_listing_view_type',
					'value' => 'list',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'ev_dealer||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||motorcycle',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_show_listing_test_drive'              => array(
			'label'        => esc_html__( 'Show Test Drive Schedule', 'motors_listing_types' ),
			'type'         => 'checkbox',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'   => $slug . '_listing_view_type',
					'value' => 'list',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'ev_dealer||aircrafts||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||motorcycle',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_show_listing_compare'                 => array(
			'label'        => esc_html__( 'Show Compare', 'motors_listing_types' ),
			'type'         => 'checkbox',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'ev_dealer||aircrafts||boats||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||motorcycle',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_show_listing_share'                   => array(
			'label'        => esc_html__( 'Show Share Block', 'motors_listing_types' ),
			'type'         => 'checkbox',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'   => $slug . '_listing_view_type',
					'value' => 'list',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'ev_dealer||aircrafts||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||motorcycle',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_show_listing_pdf'                     => array(
			'label'        => esc_html__( 'Show PDF brochure', 'motors_listing_types' ),
			'type'         => 'checkbox',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'   => $slug . '_listing_view_type',
					'value' => 'list',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'ev_dealer||aircrafts||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_show_listing_certified_logo_1'        => array(
			'label'        => esc_html__( 'Show Certified Logo 1', 'motors_listing_types' ),
			'type'         => 'checkbox',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'   => $slug . '_listing_view_type',
					'value' => 'list',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'ev_dealer||aircrafts||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_show_listing_certified_logo_2'        => array(
			'label'        => esc_html__( 'Show Certified Logo 2', 'motors_listing_types' ),
			'type'         => 'checkbox',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'   => $slug . '_listing_view_type',
					'value' => 'list',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'ev_dealer||aircrafts||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_sidebar_filter_bg'                    => array(
			'label'        => esc_html__( 'Listing Sidebar Filter Background', 'motors_listing_types' ),
			'type'         => 'image',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'listing',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_show_sold_listings'                   => array(
			'label'       => esc_html__( 'Sold Listings', 'motors_listing_types' ),
			'description' => 'Display sold listings in the Classic and Modern filters',
			'type'        => 'checkbox',
			'value'       => false,
			'submenu'     => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'  => array(
				'key'   => $slug . '_inventory_custom_settings',
				'value' => 'not_empty',
			),
		),
		$slug . '_sold_badge_bg_color'                  => array(
			'label'        => esc_html__( 'Sold Badge Background Color', 'motors_listing_types' ),
			'type'         => 'color',
			'mode'         => 'background-color',
			'value'        => '#fc4e4e',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_show_sold_listings',
					'value' => 'not_empty',
				),
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_dealer_pay_per_listing'               => array(
			'label'        => esc_html__( 'Enable Pay Per Listing', 'motors_listing_types' ),
			'type'         => 'checkbox',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_pay_per_listing_price'                => array(
			'label'        => esc_html__( 'Pay Per Listing Price', 'motors_listing_types' ),
			'type'         => 'text',
			'value'        => '0',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_dealer_pay_per_listing',
					'value' => 'not_empty',
				),
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_pay_per_listing_period'               => array(
			'label'        => esc_html__( 'Pay Per Listing Period (days)', 'motors_listing_types' ),
			'type'         => 'text',
			'value'        => '30',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_dealer_pay_per_listing',
					'value' => 'not_empty',
				),
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_dealer_payments_for_featured_listing' => array(
			'label'        => esc_html__( 'Enable Paid Featured Listing', 'motors_listing_types' ),
			'type'         => 'checkbox',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_featured_listing_default_badge'       => array(
			'label'        => esc_html__( 'Featured Listing Label', 'motors_listing_types' ),
			'type'         => 'text',
			'value'        => 'Special',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_dealer_payments_for_featured_listing',
					'value' => 'not_empty',
				),
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_featured_listing_price'               => array(
			'label'        => esc_html__( 'Featured Listing Price', 'motors_listing_types' ),
			'type'         => 'text',
			'value'        => '0',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_dealer_payments_for_featured_listing',
					'value' => 'not_empty',
				),
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
		$slug . '_featured_listing_period'              => array(
			'label'        => esc_html__( 'Featured Listing Period (days)', 'motors_listing_types' ),
			'type'         => 'text',
			'value'        => '30',
			'submenu'      => esc_html__( 'Inventory Settings', 'motors_listing_types' ),
			'dependency'   => array(
				array(
					'key'   => $slug . '_dealer_payments_for_featured_listing',
					'value' => 'not_empty',
				),
				array(
					'key'   => $slug . '_inventory_custom_settings',
					'value' => 'not_empty',
				),
				array(
					'key'     => 'multilisting_current_motors_layout',
					'value'   => 'listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
					'section' => 'listing_types',
				),
			),
			'dependencies' => '&&',
		),
	);

	$elementor_layout = ( 'temp' !== $slug && ( apply_filters( 'stm_is_layout', 'listing_five_elementor' ) || apply_filters( 'stm_is_layout', 'listing_one_elementor' ) || apply_filters( 'stm_is_layout', 'listing_two_elementor' ) || apply_filters( 'stm_is_layout', 'listing_three_elementor' ) || apply_filters( 'stm_is_layout', 'listing_four_elementor' ) ) );

	if ( $elementor_layout ) {
		unset( $conf[ $slug . '_listing_sidebar' ] );
		unset( $conf[ $slug . '_listing_filter_position' ] );
	}

	return $conf;
}

function multilisting_get_type_taxonomies( $custom_slug, $key_as_slug = false ) {
	$taxonomies = get_option( "stm_{$custom_slug}_options", array() );

	$opts = array();
	if ( ! empty( $taxonomies ) ) {
		foreach ( $taxonomies as $tax ) {
			if ( $key_as_slug ) {
				$opts[ $tax['slug'] ] = array(
					'label' => $tax['single_name'],
					'value' => $tax['slug'],
				);
			} else {
				$opts[] = array(
					'label' => $tax['single_name'],
					'value' => $tax['slug'],
				);
			}
		}
	}

	return $opts;
}

function multilisting_get_single_confs( $slug ) {
	$elementor_layout = ( 'temp' !== $slug && ( apply_filters( 'stm_is_layout', 'listing_five_elementor' ) || apply_filters( 'stm_is_layout', 'listing_one_elementor' ) || apply_filters( 'stm_is_layout', 'listing_two_elementor' ) || apply_filters( 'stm_is_layout', 'listing_three_elementor' ) || apply_filters( 'stm_is_layout', 'listing_four_elementor' ) ) );

	if ( $elementor_layout ) {

		$conf = array(
			$slug . '_single_custom_settings' => array(
				'type'        => 'group_title',
				'label'       => esc_html__( 'Listing Page Template', 'motors_listing_types' ),
				'description' => esc_html__( 'Displays in accordance with Motors Plugin Settings > Listing Detail Page > Page Templates.', 'motors_listing_types' ),
				'submenu'     => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
			),
		);

	} else {

		$conf = array(
			$slug . '_single_custom_settings'       => array(
				'type'        => 'checkbox',
				'label'       => esc_html__( 'Custom Single Listing Settings', 'motors_listing_types' ),
				'submenu'     => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'value'       => false,
				'description' => esc_html__( 'Ignores global Single Listing settings in Motors Plugin Settings', 'motors_listing_types' ),
			),
			$slug . '_show_trade_in'                => array(
				'label'        => esc_html__( 'Show Trade In Button', 'motors_listing_types' ),
				'type'         => 'checkbox',
				'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'value'        => false,
				'dependencies' => '&&',
				'dependency'   => array(
					array(
						'key'   => $slug . '_single_custom_settings',
						'value' => 'not_empty',
					),
					array(
						'key'     => 'multilisting_current_motors_layout',
						'value'   => 'ev_dealer||aircrafts||car_dealer||car_dealer_two||motorcycle||equipment',
						'section' => 'listing_types',
					),
				),
			),
			$slug . '_show_offer_price'             => array(
				'label'        => esc_html__( 'Show Offer Price Button', 'motors_listing_types' ),
				'type'         => 'checkbox',
				'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'value'        => false,
				'dependencies' => '&&',
				'dependency'   => array(
					array(
						'key'   => $slug . '_single_custom_settings',
						'value' => 'not_empty',
					),
					array(
						'key'     => 'multilisting_current_motors_layout',
						'value'   => 'ev_dealer||aircrafts||car_dealer||car_dealer_two',
						'section' => 'listing_types',
					),
				),
			),
			$slug . '_stm_car_link_quote'           =>
				array(
					'label'        => esc_html__( 'Request a Quote Link', 'motors_listing_types' ),
					'type'         => 'text',
					'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
					'dependencies' => '&&',
					'value'        => '#1578032597180-dca29e61-e895',
					'dependency'   => array(
						array(
							'key'   => $slug . '_single_custom_settings',
							'value' => 'not_empty',
						),
						array(
							'key'     => 'multilisting_current_motors_layout',
							'value'   => 'car_dealer_two||equipment||motorcycle',
							'section' => 'listing_types',
						),
					),
				),
			$slug . '_show_calculator'              => array(
				'label'        => esc_html__( 'Show Calculator', 'motors_listing_types' ),
				'type'         => 'checkbox',
				'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'value'        => false,
				'dependencies' => '&&',
				'dependency'   => array(
					array(
						'key'   => $slug . '_single_custom_settings',
						'value' => 'not_empty',
					),
					array(
						'key'     => 'multilisting_current_motors_layout',
						'value'   => 'ev_dealer||aircrafts||car_dealer||car_dealer_two||motorcycle||equipment||boats',
						'section' => 'listing_types',
					),
				),
			),
			$slug . '_show_added_date'              => array(
				'label'        => esc_html__( 'Show Published Date', 'motors_listing_types' ),
				'type'         => 'checkbox',
				'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'value'        => false,
				'dependencies' => '&&',
				'dependency'   => array(
					array(
						'key'   => $slug . '_single_custom_settings',
						'value' => 'not_empty',
					),
					array(
						'key'     => 'multilisting_current_motors_layout',
						'value'   => 'listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
						'section' => 'listing_types',
					),
				),
			),
			$slug . '_show_print_btn'               => array(
				'label'        => esc_html__( 'Show Print Button', 'motors_listing_types' ),
				'type'         => 'checkbox',
				'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'value'        => false,
				'dependencies' => '&&',
				'dependency'   => array(
					array(
						'key'   => $slug . '_single_custom_settings',
						'value' => 'not_empty',
					),
					array(
						'key'     => 'multilisting_current_motors_layout',
						'value'   => 'ev_dealer||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||car_dealer||car_dealer_two',
						'section' => 'listing_types',
					),
				),
			),
			$slug . '_show_test_drive'              => array(
				'label'        => esc_html__( 'Show Test Drive Schedule', 'motors_listing_types' ),
				'type'         => 'checkbox',
				'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'value'        => false,
				'dependencies' => '&&',
				'dependency'   => array(
					array(
						'key'   => $slug . '_single_custom_settings',
						'value' => 'not_empty',
					),
					array(
						'key'     => 'multilisting_current_motors_layout',
						'value'   => 'ev_dealer||car_dealer||car_dealer_two||equipment||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||motorcycle',
						'section' => 'listing_types',
					),
				),
			),
			$slug . '_show_stock'                   => array(
				'label'        => esc_html__( 'Show Stock', 'motors_listing_types' ),
				'type'         => 'checkbox',
				'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'value'        => false,
				'dependencies' => '&&',
				'dependency'   => array(
					array(
						'key'   => $slug . '_single_custom_settings',
						'value' => 'not_empty',
					),
					array(
						'key'     => 'multilisting_current_motors_layout',
						'value'   => 'ev_dealer||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
						'section' => 'listing_types',
					),
				),
			),
			$slug . '_show_compare'                 => array(
				'label'      => esc_html__( 'Show Compare', 'motors_listing_types' ),
				'type'       => 'checkbox',
				'submenu'    => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'value'      => false,
				'dependency' => array(
					'key'   => $slug . '_single_custom_settings',
					'value' => 'not_empty',
				),
			),
			$slug . '_show_share'                   => array(
				'label'        => esc_html__( 'Show Share Block', 'motors_listing_types' ),
				'type'         => 'checkbox',
				'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'value'        => false,
				'dependencies' => '&&',
				'dependency'   => array(
					array(
						'key'   => $slug . '_single_custom_settings',
						'value' => 'not_empty',
					),
					array(
						'key'     => 'multilisting_current_motors_layout',
						'value'   => 'ev_dealer||aircrafts||car_dealer||car_dealer_two||car_magazine||equipment||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||motorcycle',
						'section' => 'listing_types',
					),
				),
			),
			$slug . '_show_pdf'                     => array(
				'label'        => esc_html__( 'Show PDF brochure', 'motors_listing_types' ),
				'type'         => 'checkbox',
				'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'value'        => false,
				'dependencies' => '&&',
				'dependency'   => array(
					array(
						'key'   => $slug . '_single_custom_settings',
						'value' => 'not_empty',
					),
					array(
						'key'     => 'multilisting_current_motors_layout',
						'value'   => 'ev_dealer||aircrafts||car_dealer||car_dealer_two||car_magazine||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||motorcycle',
						'section' => 'listing_types',
					),
				),
			),
			$slug . '_show_certified_logo_1'        => array(
				'label'        => esc_html__( 'Show Certified Logo 1', 'motors_listing_types' ),
				'type'         => 'checkbox',
				'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'value'        => false,
				'dependencies' => '&&',
				'dependency'   => array(
					array(
						'key'   => $slug . '_single_custom_settings',
						'value' => 'not_empty',
					),
					array(
						'key'     => 'multilisting_current_motors_layout',
						'value'   => 'ev_dealer||aircrafts||car_dealer||car_dealer_two||car_magazine||equipment||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||motorcycle',
						'section' => 'listing_types',
					),
				),
			),
			$slug . '_show_certified_logo_2'        => array(
				'label'        => esc_html__( 'Show Certified Logo 2', 'motors_listing_types' ),
				'type'         => 'checkbox',
				'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'value'        => false,
				'dependencies' => '&&',
				'dependency'   => array(
					array(
						'key'   => $slug . '_single_custom_settings',
						'value' => 'not_empty',
					),
					array(
						'key'     => 'multilisting_current_motors_layout',
						'value'   => 'ev_dealer||aircrafts||car_dealer||car_dealer_two||car_magazine||equipment||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||motorcycle',
						'section' => 'listing_types',
					),
				),
			),
			$slug . '_show_featured_btn'            => array(
				'label'        => esc_html__( 'Show Featured Button', 'motors_listing_types' ),
				'type'         => 'checkbox',
				'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'value'        => false,
				'dependencies' => '&&',
				'dependency'   => array(
					array(
						'key'   => $slug . '_single_custom_settings',
						'value' => 'not_empty',
					),
					array(
						'key'     => 'multilisting_current_motors_layout',
						'value'   => 'listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
						'section' => 'listing_types',
					),
				),
			),
			$slug . '_show_vin'                     => array(
				'label'        => esc_html__( 'Show VIN', 'motors_listing_types' ),
				'type'         => 'checkbox',
				'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'value'        => false,
				'dependencies' => '&&',
				'dependency'   => array(
					array(
						'key'   => $slug . '_single_custom_settings',
						'value' => 'not_empty',
					),
					array(
						'key'     => 'multilisting_current_motors_layout',
						'value'   => 'ev_dealer||car_dealer||car_dealer_two||equipment||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
						'section' => 'listing_types',
					),
				),
			),
			$slug . '_show_search_results'          => array(
				'label'        => esc_html__( 'Show Search Results', 'motors_listing_types' ),
				'type'         => 'checkbox',
				'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'value'        => false,
				'dependencies' => '&&',
				'dependency'   => array(
					array(
						'key'   => $slug . '_single_custom_settings',
						'value' => 'not_empty',
					),
					array(
						'key'     => 'multilisting_current_motors_layout',
						'value'   => 'ev_dealer||car_dealer||car_dealer_two||equipment||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
						'section' => 'listing_types',
					),
				),
			),
			$slug . '_search_results_full_width'    => array(
				'label'        => esc_html__( 'Full Width Search Results', 'motors_listing_types' ),
				'type'         => 'checkbox',
				'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'value'        => false,
				'dependencies' => '&&',
				'dependency'   => array(
					array(
						'key'   => $slug . '_single_custom_settings',
						'value' => 'not_empty',
					),
					array(
						'key'   => $slug . '_show_search_results',
						'value' => 'not_empty',
					),
					array(
						'key'     => 'multilisting_current_motors_layout',
						'value'   => 'ev_dealer||car_dealer||car_dealer_two||equipment||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
						'section' => 'listing_types',
					),
				),
			),

			$slug . '_search_results_desktop_items' =>
				array(
					'label'        => esc_html__( 'Number of Items on Desktop', 'motors_listing_types' ),
					'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
					'type'         => 'select',
					'description'  => esc_html__( 'Minimum width: 1025px.', 'motors_listing_types' ),
					'options'      =>
						array(
							'4' => '4 items',
							'5' => '5 items',
							'6' => '6 items',
						),
					'value'        => '4',
					'dependencies' => '&&',
					'dependency'   => array(
						array(
							'key'   => $slug . '_single_custom_settings',
							'value' => 'not_empty',
						),
						array(
							'key'   => $slug . '_search_results_full_width',
							'value' => 'not_empty',
						),
						array(
							'key'     => 'multilisting_current_motors_layout',
							'value'   => 'ev_dealer||car_dealer||car_dealer_two||equipment||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
							'section' => 'listing_types',
						),
					),
				),

			$slug . '_search_results_tablet_items'  =>
				array(
					'label'        => esc_html__( 'Number of Items on Tablet', 'motors_listing_types' ),
					'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
					'type'         => 'select',
					'description'  => esc_html__( 'Minimum width: 768px.', 'motors_listing_types' ),
					'options'      =>
						array(
							'2' => '2 items',
							'3' => '3 items',
							'4' => '4 items',
						),
					'value'        => '3',
					'dependencies' => '&&',
					'dependency'   => array(
						array(
							'key'   => $slug . '_single_custom_settings',
							'value' => 'not_empty',
						),
						array(
							'key'   => $slug . '_search_results_full_width',
							'value' => 'not_empty',
						),
						array(
							'key'     => 'multilisting_current_motors_layout',
							'value'   => 'ev_dealer||car_dealer||car_dealer_two||equipment||listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
							'section' => 'listing_types',
						),
					),
				),

			$slug . '_show_registered'              => array(
				'label'        => esc_html__( 'Show Registered Date', 'motors_listing_types' ),
				'type'         => 'checkbox',
				'value'        => false,
				'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'dependencies' => '&&',
				'dependency'   => array(
					array(
						'key'   => $slug . '_single_custom_settings',
						'value' => 'not_empty',
					),
					array(
						'key'     => 'multilisting_current_motors_layout',
						'value'   => 'listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
						'section' => 'listing_types',
					),
				),
			),
			$slug . '_show_history'                 => array(
				'label'        => esc_html__( 'Show History', 'motors_listing_types' ),
				'type'         => 'checkbox',
				'value'        => false,
				'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'dependencies' => '&&',
				'dependency'   => array(
					array(
						'key'   => $slug . '_single_custom_settings',
						'value' => 'not_empty',
					),
					array(
						'key'     => 'multilisting_current_motors_layout',
						'value'   => 'listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor||equipment||motorcycle',
						'section' => 'listing_types',
					),
				),
			),
			$slug . '_stm_show_number'              => array(
				'label'        => esc_html__( 'Show Number', 'motors_listing_types' ),
				'type'         => 'checkbox',
				'value'        => false,
				'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'dependencies' => '&&',
				'dependency'   => array(
					array(
						'key'   => $slug . '_single_custom_settings',
						'value' => 'not_empty',
					),
					array(
						'key'     => 'multilisting_current_motors_layout',
						'value'   => 'listing||listing_two||listing_three||listing_four||listing_five||listing_six||listing_one_elementor||listing_two_elementor||listing_three_elementor||listing_four_elementor||listing_five_elementor',
						'section' => 'listing_types',
					),
				),
			),
			$slug . '_stm_similar_query'            => array(
				'label'        => esc_html__( 'Show Similar Listings by Parameter', 'motors_listing_types' ),
				'type'         => 'text',
				'description'  => sprintf( esc_html__( 'Enter slug of listing category, separated by comma, without spaces. Ex: %1$s-make,%2$s-condition', 'motors_listing_types' ), $slug, $slug ),
				'value'        => '',
				'submenu'      => esc_html__( 'Single Listing Settings', 'motors_listing_types' ),
				'dependencies' => '&&',
				'dependency'   => array(
					array(
						'key'     => 'multilisting_current_motors_layout',
						'value'   => 'listing||listing_two||listing_three||listing_four||listing_five||listing_six',
						'section' => 'listing_types',
					),
				),
			),
		);

	}

	return $conf;
}

function multilisting_get_add_listing_confs( $slug ) {
	$conf = array();

	$elementor_layout = ( 'temp' !== $slug && ( apply_filters( 'stm_is_layout', 'listing_five_elementor' ) || apply_filters( 'stm_is_layout', 'listing_one_elementor' ) || apply_filters( 'stm_is_layout', 'listing_two_elementor' ) || apply_filters( 'stm_is_layout', 'listing_three_elementor' ) || apply_filters( 'stm_is_layout', 'listing_four_elementor' ) ) );

	if ( $elementor_layout ) {

		$conf = array(
			$slug . '_addl_group_ds_title'          => array(
				'type'             => 'group_title',
				'label'            => esc_html__( 'Description & Slots', 'motors_listing_types' ),
				'submenu'          => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
				'preview'          => MULTILISTING_PLUGIN_URL . '/assets/img/wpcfto/desc_slots.png',
				'preview_position' => 'preview_bottom',
				'group'            => 'started',
			),
			$slug . '_addl_title'                   => array(
				'label'   => esc_html__( 'Title', 'motors_listing_types' ),
				'type'    => 'text',
				'value'   => esc_html__( 'Build Your Ad', 'motors_listing_types' ),
				'submenu' => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
			),
			$slug . '_addl_description'             => array(
				'label'   => esc_html__( 'Description', 'motors_listing_types' ),
				'type'    => 'editor',
				'submenu' => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
			),
			$slug . '_addl_show_slots'              => array(
				'label'   => esc_html__( 'Available Slots', 'motors_listing_types' ),
				'type'    => 'checkbox',
				'value'   => true,
				'submenu' => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
			),
			$slug . '_addl_slots_title'             => array(
				'label'      => esc_html__( 'Label', 'motors_listing_types' ),
				'type'       => 'text',
				'value'      => esc_html__( 'Slots available', 'motors_listing_types' ),
				'submenu'    => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
				'group'      => 'ended',
				'dependency' => array(
					'key'   => $slug . '_addl_show_slots',
					'value' => 'not_empty',
				),
			),
			$slug . '_addl_group_lt_title'          => array(
				'type'             => 'group_title',
				'label'            => esc_html__( 'Title', 'motors_listing_types' ),
				'preview'          => MULTILISTING_PLUGIN_URL . '/assets/img/wpcfto/item_title.png',
				'preview_position' => 'preview_bottom',
				'submenu'          => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
				'group'            => 'started',
			),
			$slug . '_addl_car_title'               => array(
				'label'       => esc_html__( 'Custom Title', 'motors_listing_types' ),
				'description' => 'Enables input field for listing title. The generated title can be controlled in Inventory Settings > Grid/List Card > Display Generated Car Title as',
				'type'        => 'checkbox',
				'value'       => false,
				'submenu'     => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
				'group'       => 'ended',
			),
			$slug . '_addl_group_details_title'     => array(
				'type'             => 'group_title',
				'label'            => esc_html__( 'Details', 'motors_listing_types' ),
				'preview'          => MULTILISTING_PLUGIN_URL . '/assets/img/wpcfto/item_details.png',
				'preview_position' => 'preview_bottom',
				'submenu'          => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
				'group'            => 'started',
			),
			$slug . '_addl_required_fields'         => array(
				'label'       => esc_html__( 'Required Categories', 'motors_listing_types' ),
				'description' => 'Add new <a href="' . admin_url( 'edit.php?post_type=' . $slug . '&page=' . $slug . '_categories' ) . '" target="_blank">category</a>',
				'type'        => 'multi_checkbox',
				'options'     => multilisting_get_main_taxonomies_to_fill( $slug ),
				'submenu'     => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
			),
			$slug . '_addl_number_as_input'         => array(
				'label'       => esc_html__( 'Transform numeric categories to input fields', 'motors_listing_types' ),
				'description' => esc_html__( 'Applies to Required Categories', 'motors_listing_types' ),
				'type'        => 'checkbox',
				'value'       => true,
				'submenu'     => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
			),
			$slug . '_addl_show_registered'         => array(
				'label'   => esc_html__( 'Registered Date', 'motors_listing_types' ),
				'type'    => 'checkbox',
				'value'   => true,
				'submenu' => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
			),
			$slug . '_addl_show_vin'                => array(
				'label'   => esc_html__( 'VIN', 'motors_listing_types' ),
				'type'    => 'checkbox',
				'value'   => true,
				'submenu' => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
			),
			$slug . '_addl_show_history'            => array(
				'label'   => esc_html__( 'History', 'motors_listing_types' ),
				'type'    => 'checkbox',
				'value'   => true,
				'submenu' => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
			),
			$slug . '_addl_history_report'          => array(
				'label'       => esc_html__( 'Allowed Histories', 'motors_listing_types' ),
				'description' => esc_html__( 'Enter allowed histories, separated by a comma. Example - (Carfax, AutoCheck, Carfax 1 Owner, etc)', 'motors_listing_types' ),
				'type'        => 'text',
				'value'       => 'Carfax, AutoCheck',
				'submenu'     => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
				'dependency'  => array(
					'key'   => $slug . '_addl_show_history',
					'value' => 'not_empty',
				),
			),
			$slug . '_addl_details_location'        => array(
				'label'   => esc_html__( 'Location', 'motors_listing_types' ),
				'type'    => 'checkbox',
				'value'   => true,
				'submenu' => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
				'group'   => 'ended',
			),
			$slug . '_addl_group_features_title'    => array(
				'type'             => 'group_title',
				'label'            => esc_html__( 'Features', 'motors_listing_types' ),
				'description'      => wp_kses_post( '<a href="' . get_site_url() . '/wp-admin/edit-tags.php?taxonomy=stm_additional_features&post_type=' . $slug . '" target="_blank">All Features</a>' ),
				'preview'          => MULTILISTING_PLUGIN_URL . '/assets/img/wpcfto/item_features.png',
				'preview_position' => 'preview_bottom',
				'submenu'          => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
			),
			$slug . '_addl_group_gallery_title'     => array(
				'type'             => 'group_title',
				'label'            => esc_html__( 'Gallery', 'motors_listing_types' ),
				'preview'          => MULTILISTING_PLUGIN_URL . '/assets/img/wpcfto/item_gallery.png',
				'preview_position' => 'preview_bottom',
				'submenu'          => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
				'group'            => 'started',
			),
			$slug . '_addl_gallery_content'         => array(
				'type'    => 'editor',
				'label'   => esc_html__( 'Description', 'motors_listing_types' ),
				'submenu' => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
				'group'   => 'ended',
			),
			$slug . '_addl_group_video_title'       => array(
				'type'             => 'group_title',
				'label'            => esc_html__( 'Videos', 'motors_listing_types' ),
				'preview'          => MULTILISTING_PLUGIN_URL . '/assets/img/wpcfto/item_videos.png',
				'preview_position' => 'preview_bottom',
				'submenu'          => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
				'group'            => 'started',
			),
			$slug . '_addl_video_content'           => array(
				'type'    => 'editor',
				'label'   => esc_html__( 'Description', 'motors_listing_types' ),
				'submenu' => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
				'group'   => 'ended',
			),
			$slug . '_addl_group_seller_note_title' => array(
				'type'             => 'group_title',
				'label'            => esc_html__( 'Seller Note', 'motors_listing_types' ),
				'preview'          => MULTILISTING_PLUGIN_URL . '/assets/img/wpcfto/item_seller_note.png',
				'preview_position' => 'preview_bottom',
				'submenu'          => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
				'group'            => 'started',
			),
			$slug . '_addl_seller_note_content'     => array(
				'type'        => 'editor',
				'label'       => esc_html__( 'Template Phrases', 'motors_listing_types' ),
				'description' => esc_html__( 'Enter phrases, separated by a comma. Example - (Excellent condition, Always garaged, etc)', 'motors_listing_types' ),
				'submenu'     => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
				'group'       => 'ended',
			),
			$slug . '_addl_group_plans_title'       => array(
				'type'             => 'group_title',
				'label'            => esc_html__( 'Subscription Plans', 'motors_listing_types' ),
				'description'      => esc_html__( 'Displays in accordance with Motors Plugin Settings > Monetization > Subscription model setting.', 'motors_listing_types' ),
				'preview'          => MULTILISTING_PLUGIN_URL . '/assets/img/wpcfto/item_plan.png',
				'preview_position' => 'preview_bottom',
				'icon'             => 'fa fa-clock',
				'submenu'          => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
			),
			$slug . '_addl_group_price_title'       => array(
				'type'             => 'group_title',
				'label'            => esc_html__( 'Price', 'motors_listing_types' ),
				'preview'          => MULTILISTING_PLUGIN_URL . '/assets/img/wpcfto/item_price.png',
				'preview_position' => 'preview_bottom',
				'submenu'          => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
				'group'            => 'started',
			),
			$slug . '_addl_price_title'             => array(
				'type'    => 'text',
				'label'   => esc_html__( 'Title', 'motors_listing_types' ),
				'submenu' => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
			),
			$slug . '_addl_price_label_text'        => array(
				'type'    => 'text',
				'label'   => esc_html__( 'Price Label', 'motors_listing_types' ),
				'submenu' => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
				'preview' => MULTILISTING_PLUGIN_URL . '/assets/img/wpcfto/tooltip_price.jpg',
			),
			$slug . '_addl_show_sale_price_label'   => array(
				'type'    => 'checkbox',
				'label'   => esc_html__( 'Sale Price', 'motors_listing_types' ),
				'submenu' => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
			),
			$slug . '_addl_sale_price_label'        => array(
				'type'       => 'text',
				'label'      => esc_html__( 'Sale Price Label', 'motors_listing_types' ),
				'submenu'    => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
				'preview'    => MULTILISTING_PLUGIN_URL . '/assets/img/wpcfto/tooltip_sale_price.jpg',
				'dependency' => array(
					'key'   => $slug . '_addl_show_sale_price_label',
					'value' => 'not_empty',
				),
			),
			$slug . '_addl_show_custom_label'       => array(
				'type'    => 'checkbox',
				'label'   => esc_html__( 'Custom Label', 'motors_listing_types' ),
				'submenu' => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
			),
			$slug . '_addl_price_desc'              => array(
				'type'    => 'editor',
				'label'   => esc_html__( 'Description', 'motors_listing_types' ),
				'submenu' => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
				'group'   => 'ended',
			),
			$slug . '_addl_group_reg_login_title'   => array(
				'type'        => 'group_title',
				'label'       => esc_html__( 'Register/Login', 'motors_listing_types' ),
				'description' => esc_html__( 'Displays in accordance with Motors Plugin Settings > Listing Detail Page > Listing Creation Form > User registration/login.', 'motors_listing_types' ),
				'icon'        => 'fa fa-clock',
				'submenu'     => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
			),
			$slug . '_sorted_steps'                 => array(
				'type'        => 'group_title',
				'label'       => esc_html__( 'Sort Layouts', 'motors_listing_types' ),
				'description' => esc_html__( 'Displays in accordance with Motors Plugin Settings > Listing Detail Page > Layout Builder', 'motors_listing_types' ),
				'icon'        => 'fa fa-clock',
				'submenu'     => esc_html__( 'Add Listing Settings', 'motors_listing_types' ),
			),
		);

	}

	return $conf;
}

function multilisting_get_features_confs( $slug ) {
	$conf = array();

	$elementor_layout = ( 'temp' !== $slug && ( apply_filters( 'stm_is_layout', 'listing_five_elementor' ) || apply_filters( 'stm_is_layout', 'listing_one_elementor' ) || apply_filters( 'stm_is_layout', 'listing_two_elementor' ) || apply_filters( 'stm_is_layout', 'listing_three_elementor' ) || apply_filters( 'stm_is_layout', 'listing_four_elementor' ) ) );

	if ( $elementor_layout ) {
		$options      = get_option( 'stm_motors_listing_types' );
		$new_settings = ( ! empty( $options[ $slug . '_fs_user_features' ] ) ) ? $options[ $slug . '_fs_user_features' ] : array();
		if ( empty( $new_settings ) ) {
			$features     = multilisting_get_features_list();
			$old_settings = $options[ $slug . '_addl_user_features' ] ?? array();

			if ( ! empty( $old_settings ) ) {
				foreach ( $old_settings as $k => $old_setting ) {
					$old_features        = explode( ',', $old_setting['tab_title_labels'] );
					$features_for_select = array();
					foreach ( $features as $feature ) {
						if ( in_array( $feature['label'], $old_features, true ) ) {
							$features_for_select[] = $feature;
						}
					}
					$old_settings[ $k ]['tab_title_selected_labels'] = $features_for_select;
				}
			}
			$options[ $slug . '_fs_user_features' ] = $old_settings;
			update_option( 'stm_motors_listing_types', $options );
			do_action( 'stm_print_styles_color' );
		}

		$conf = array(
			$slug . '_fs_user_features' => array(
				'type'    => 'repeater',
				'label'   => esc_html__( 'Features', 'motors_listing_types' ),
				'fields'  => array(
					'tab_title_single'          => array(
						'type'  => 'text',
						'label' => esc_html__( 'Title', 'motors_listing_types' ),
					),
					'tab_title_selected_labels' => array(
						'type'    => 'multiselect',
						'label'   => esc_html__( 'Features list', 'motors_listing_types' ),
						'options' => multilisting_get_features_list(),
					),
				),
				'value'   => $new_settings,
				'submenu' => esc_html__( 'Features Settings', 'motors_listing_types' ),
			),
		);

	}

	return $conf;
}

function multilisting_get_features_list() {
	global $wpdb;

	$terms         = $wpdb->get_results( $wpdb->prepare( "SELECT t.* FROM {$wpdb->prefix}terms AS t LEFT JOIN {$wpdb->prefix}term_taxonomy AS tt ON t.term_id = tt.term_id WHERE tt.taxonomy=%s", 'stm_additional_features' ) );
	$features_list = array();

	if ( ! is_wp_error( $terms ) ) {
		foreach ( $terms as $key => $feature ) {
			$features_list[ $key ]['label'] = $feature->name;
			$features_list[ $key ]['value'] = $feature->slug;
		}
	}

	return $features_list;
}

function multilisting_get_main_taxonomies_to_fill( $slug ) {
	$filter_options = get_option( 'stm_' . $slug . '_options', array() );

	$taxonomies = array();

	if ( ! empty( $filter_options ) ) {
		foreach ( $filter_options as $filter_option ) {
			if ( $filter_option['use_on_car_filter'] ) {
				$taxonomies[ $filter_option['slug'] ] = $filter_option['single_name'];
			}
		}
	}

	return $taxonomies;
}

// get array of config key names
function multilisting_get_default_confs_array() {
	$inventory = multilisting_get_inventory_confs( 'temp' );
	$single    = multilisting_get_single_confs( 'temp' );

	$array = array(
		'inventory' => array(),
		'single'    => array(),
	);

	foreach ( $inventory as $key => $conf ) {
		if ( 'temp_inventory_custom_settings' !== $key ) {
			array_push( $array['inventory'], str_replace( 'temp_', '', $key ) );
		}
	}

	foreach ( $single as $key => $conf ) {
		if ( 'temp_single_custom_settings' !== $key ) {
			array_push( $array['single'], str_replace( 'temp_', '', $key ) );
		}
	}

	return $array;
}

function multilisting_override_default_configuration( $option_value = '', $option_name = '' ) {
	$post_type = STMMultiListing::stm_get_current_listing_slug();

	$confs = multilisting_get_default_confs_array();

	if ( ! empty( $post_type ) ) {
		$options = get_option( 'stm_motors_listing_types' );

		// inventory setting
		if ( in_array( $option_name, $confs['inventory'], true ) ) {
			// custom settings enabled for post type inventory
			if ( isset( $options[ $post_type . '_inventory_custom_settings' ] ) && true === $options[ $post_type . '_inventory_custom_settings' ] ) {
				return ( empty( $options[ $post_type . '_' . $option_name ] ) ) ? false : $options[ $post_type . '_' . $option_name ];
			}
		}

		// single setting
		if ( in_array( $option_name, $confs['single'], true ) ) {
			// custom settings enabled for post type inventory
			if ( isset( $options[ $post_type . '_single_custom_settings' ] ) && true === $options[ $post_type . '_single_custom_settings' ] ) {
				return $options[ $post_type . '_' . $option_name ];
			}
		}
	}

	return $option_value;
}


// register hooks
$all_confs = multilisting_get_default_confs_array();
$confs     = array_merge( $all_confs['inventory'], $all_confs['single'] );
foreach ( $confs as $key => $conf_name ) {
	add_filter( 'wpcfto_motors_' . $conf_name, 'multilisting_override_default_configuration', PHP_INT_MAX, 2 );
}


// check if listing types changed
add_filter( 'wpcfto_reload_after_save', 'reload_page_when_type_slugs_change', 10, 2 );
function reload_page_when_type_slugs_change( $id, $settings ) {
	if ( 'stm_motors_listing_types' === $id ) {
		$old = stm_wpcfto_get_options( 'stm_motors_listing_types' );

		if ( ! is_array( $settings['multilisting_repeater'] ) || ! is_array( $old['multilisting_repeater'] ) ) {
			return true; //reload the page to see the changes
		}

		// if number of post types changed
		if ( count( $settings['multilisting_repeater'] ) !== count( $old['multilisting_repeater'] ) ) {
			return true;
		}

		// number hasn't changed, let's check for slug changes
		$new_slugs = array_column( $settings['multilisting_repeater'], 'slug' );
		$old_slugs = array_column( $old['multilisting_repeater'], 'slug' );

		$a = array_diff( $new_slugs, $old_slugs );
		$b = array_diff( $old_slugs, $new_slugs );
		if ( count( $a ) > 0 || count( $b ) > 0 ) {
			return true;
		}
	}

	return false;
}

// validate slug
add_action( 'wpcfto_after_settings_saved', 'stm_prevent_identical_type_slugs', 15, 2 );
function stm_prevent_identical_type_slugs( $id, $settings ) {
	if ( 'stm_motors_listing_types' === $id ) {
		if ( ! empty( $settings['multilisting_repeater'] ) ) {

			$slugs = array();

			foreach ( $settings['multilisting_repeater'] as $key => $item ) {
				if ( empty( $item['label'] ) && empty( $item['slug'] ) ) {
					continue;
				}
				$slugs[ $key ] = ( empty( $item['slug'] ) ) ? sanitize_title( $item['label'] ) : sanitize_title( $item['slug'] );
			}

			$new_settings = $settings;

			foreach ( $settings['multilisting_repeater'] as $key => $item ) {
				if ( empty( $item['label'] ) && empty( $item['slug'] ) ) {
					unset( $new_settings['multilisting_repeater'][ $key ] );
					continue;
				}

				$slug  = ( empty( $item['slug'] ) ) ? sanitize_title( $item['label'] ) : sanitize_title( $item['slug'] );
				$found = array_keys( $slugs, $slug, true );

				// if slug already exists
				if ( count( $found ) > 1 && $key > 0 ) {
					$new_settings['multilisting_repeater'][ $key ]['slug'] = $slug . '-' . $key;
				} else {
					$new_settings['multilisting_repeater'][ $key ]['slug'] = $slug;
				}

				// assign default label if no label provided
				if ( empty( $item['label'] ) ) {
					$new_settings['multilisting_repeater'][ $key ]['label'] = esc_html__( 'Custom Listing', 'motors_listing_types' );
				}
			}

			update_option( $id, $new_settings );
		}
	}
}


function stm_get_listings_filter( $result, $slug, $args = array( 'use_on_car_filter' => true ), $filter = true ) {
	$args = wp_parse_args(
		$args,
		array(
			'where'  => array(),
			'key_by' => '',
		)
	);

	$data = array_filter( (array) get_option( "stm_{$slug}_options" ) );

	if ( apply_filters( 'stm_listings_post_type', 'listings' ) === $slug ) {
		add_option( 'mlt_bypass_options_hook', 'yes' );
		$data = array_filter( (array) get_option( 'stm_vehicle_listing_options' ) );
	}

	foreach ( $data as $key => $_data ) {
		$passed = true;
		foreach ( $args['where'] as $_field => $_val ) {
			if ( array_key_exists( $_field, $_data ) && boolval( $_data[ $_field ] ) !== boolval( $_val ) ) {
				$passed = false;
				break;
			}
		}

		if ( $passed ) {
			if ( $args['key_by'] ) {
				$result[ $_data[ $args['key_by'] ] ] = $_data;
			} else {
				$result[] = $_data;
			}
		}
	}

	if ( $filter ) {
		$result = apply_filters( 'stm_listings_attributes', $result, $args );
	}

	return $result;

}

add_filter( 'stm_get_listings_filter', 'stm_get_listings_filter', 10, 4 );


add_filter( 'stm_listings_ajax_results', 'multilisting_remove_posttype_url', 100 );
function multilisting_remove_posttype_url( $args ) {
	$excluded_params = apply_filters(
		'stm_url_excluded_params',
		array(
			'posttype',
			'ajax_action',
			'fragments',
			'stm_location_address',
		)
	);

	if ( ! is_array( $excluded_params ) ) {
		$excluded_params = array();
	}

	if ( isset( $r['stm_lat'] ) && isset( $r['stm_lng'] ) && ! isset( $r['ca_location'] ) ) {
		$excluded_params[] = 'stm_lat';
		$excluded_params[] = 'stm_lng';
	}

	$args['url'] = remove_query_arg( $excluded_params );

	return $args;
}

add_action( 'wp_enqueue_scripts', 'multilisting_front_enqueue_scripts_styles' );
function multilisting_front_enqueue_scripts_styles() {

	wp_enqueue_style( 'multilisting', MULTILISTING_PLUGIN_URL . '/assets/css/multilisting.css', null, time(), 'all' );

	wp_enqueue_style( 'multilisting-grid', MULTILISTING_PLUGIN_URL . '/assets/css/stm-grid.css', null, MULTILISTING_V, 'all' );

	wp_enqueue_script(
		'multilisting',
		MULTILISTING_PLUGIN_URL . '/assets/js/multilisting.js',
		array( 'listings-filter' ),
		time(),
		true
	);
}

add_action( 'admin_enqueue_scripts', 'multilisting_admin_enqueue_scripts_styles' );
function multilisting_admin_enqueue_scripts_styles() {

	wp_enqueue_style( 'multilisting', MULTILISTING_PLUGIN_URL . '/assets/css/multilisting.css', null, time(), 'all' );

	wp_enqueue_script(
		'multilisting',
		MULTILISTING_PLUGIN_URL . '/assets/js/multilisting.js',
		array(
			'jquery',
			'jquery-ui-droppable',
			'jquery-ui-datepicker',
			'jquery-ui-sortable',
		),
		time(),
		true
	);

	wp_enqueue_script( 'jquery-ui-sortable' );

	if ( defined( 'STM_LISTINGS_URL' ) ) {
		wp_enqueue_script( 'stm-theme-multiselect', STM_LISTINGS_URL . '/assets/js/jquery.multi-select.js', array( 'jquery' ) );//phpcs:ignore

		wp_enqueue_script(
			'stm-listings-js',
			STM_LISTINGS_URL . '/assets/js/vehicles-listing.js',
			array(
				'jquery',
				'jquery-ui-droppable',
				'jquery-ui-datepicker',
				'jquery-ui-sortable',
			),
			'6.5.8.1'
		);//phpcs:ignore
	}

	wp_localize_script(
		'multilisting',
		'stm_listings',
		array(
			'listings' => STMMultiListing::stm_get_listings(),
		)
	);

}

function stm_get_single_car_multilisting( $post_type ) {
	$args = array(
		'where'  => array( 'use_on_single_car_page' => true ),
		'key_by' => '',
	);

	$result = array();
	$data   = array_filter( (array) get_option( "stm_{$post_type}_options" ) );

	foreach ( $data as $key => $_data ) {
		$passed = true;
		foreach ( $args['where'] as $_field => $_val ) {
			if ( array_key_exists( $_field, $_data ) && boolval( $_data[ $_field ] ) !== boolval( $_val ) ) {
				$passed = false;
				break;
			}
		}

		if ( $passed ) {
			if ( $args['key_by'] ) {
				$result[ $_data[ $args['key_by'] ] ] = $_data;
			} else {
				$result[] = $_data;
			}
		}
	}

	return apply_filters( 'stm_listings_attributes', $result, $args );
}


function stm_get_custom_taxonomy_pt_count( $slug, $taxonomy, $pt ) {
	// this is cached function, so we can use it
	$total = 0;

	$args = array(
		'post_type'        => $pt,
		'post_status'      => 'publish',
		'posts_per_page'   => 1,
		'suppress_filters' => 0,
	);
	$meta = array(
		'relation' => 'AND',
		array(
			'key'     => 'car_mark_as_sold',
			'value'   => '',
			'compare' => '=',
		),
	);

	if ( ! empty( $slug ) && ! empty( $taxonomy ) ) {
		$args['tax_query'] = array(
			array(
				'taxonomy' => $taxonomy,
				'terms'    => $slug,
				'field'    => 'slug',
			),
		);
	}
	if ( ! empty( $taxonomy ) && is_array( $taxonomy ) ) {
		if ( 'listings' === $pt ) {
			$filter_options = get_option( 'stm_vehicle_listing_options' );
		} else {
			$filter_options = get_option( "stm_{$pt}_options", array() );
		}

		foreach ( $taxonomy as $tax ) {
			if ( ! empty( $filter_options ) ) {

				$taxonomy_info = array();

				foreach ( $filter_options as $filter_option ) {
					if ( $filter_option['slug'] === $tax ) {
						$taxonomy_info = $filter_option;
					}
				}

				if ( ! empty( $taxonomy_info['numeric'] ) && $taxonomy_info['numeric'] ) {
					$__args = array(
						'orderby'    => 'name',
						'order'      => 'ASC',
						'hide_empty' => false,
						'fields'     => 'all',
					);

					$numbers = array();

					$terms = get_terms( $tax, $__args );

					if ( ! empty( $terms ) ) {
						foreach ( $terms as $term ) {
							$numbers[] = intval( $term->name );
						}
					}

					sort( $numbers );

					$start_value = ! empty( current( $numbers ) ) ? current( $numbers ) : 0;
					$end_value   = ! empty( end( $numbers ) ) ? end( $numbers ) : 0;

					$meta[1]['relation'] = 'AND';
					$meta[1][]           = array(
						'key'     => $tax,
						'value'   => $start_value,
						'compare' => '>=',
						'type'    => 'NUMERIC',
					);
					$meta[1][]           = array(
						'key'     => $tax,
						'value'   => $end_value,
						'compare' => '<=',
						'type'    => 'NUMERIC',
					);

					continue;
				}
			}
		}
	}

	$args['meta_query'] = $meta;

	$count_posts = new WP_Query( $args );
	if ( ! is_wp_error( $count_posts ) ) {
		$total = $count_posts->found_posts;
	}

	if ( ! empty( $slug ) && ! empty( $taxonomy ) ) {
		$total = wp_count_posts( $pt );
		$total = $total->publish;
	}

	return $total;
}


if ( ! function_exists( 'stm_user_listings_query' ) ) {
	function stm_user_listings_query( $user_id, $status = 'publish', $per_page = - 1, $popular = false, $offset = 0, $data_desc = false, $get_all = false ) {
		$pay_per_listing = ( $get_all ) ? array() : array(
			'key'     => 'pay_per_listing',
			'compare' => 'NOT EXISTS',
			'value'   => '',
		);

		$post_types = array( apply_filters( 'stm_listings_post_type', 'listings' ) );
		$listings   = STMMultiListing::stm_get_listings();
		if ( ! empty( $listings ) ) {
			foreach ( $listings as $key => $listing ) {
				array_push( $post_types, $listing['slug'] );
			}
		}

		if ( isset( $_GET['listing_type'] ) && ! empty( $_GET['listing_type'] ) && in_array( $_GET['listing_type'], $post_types, true ) ) { //phpcs:ignore
			$post_types = array( $_GET['listing_type'] );
		}

		$args = array(
			'post_type'      => $post_types,
			'post_status'    => $status,
			'posts_per_page' => $per_page,
			'offset'         => $offset,
			'author'         => $user_id,
			'meta_query'     => array(
				'relation' => 'AND',
				array(
					'key'     => 'stm_car_user',
					'value'   => $user_id,
					'compare' => '=',
				),
				$pay_per_listing,
			),
		);

		if ( $popular ) {
			$args['order']   = 'ASC';
			$args['orderby'] = 'stm_car_views';
		}

		$query = new WP_Query( $args );
		wp_reset_postdata();

		return $query;

	}
}

function stm_user_multilistings_query(
	$user_id,
	$status = 'publish',
	$post_type = 'listings',
	$per_page = - 1,
	$popular = false,
	$offset = 0,
	$data_desc = false,
	$get_all = false
) {
	$pay_per_listing = ( $get_all ) ? array() : array(
		'key'     => 'pay_per_listing',
		'compare' => 'NOT EXISTS',
		'value'   => '',
	);

	$args = array(
		'post_type'      => $post_type,
		'post_status'    => $status,
		'posts_per_page' => $per_page,
		'offset'         => $offset,
		'meta_query'     => array(
			'relation' => 'AND',
			array(
				'key'     => 'stm_car_user',
				'value'   => $user_id,
				'compare' => '=',
			),
			$pay_per_listing,
		),
	);

	if ( $popular ) {
		$args['order']   = 'ASC';
		$args['orderby'] = 'stm_car_views';
	}

	$query = new WP_Query( $args );
	wp_reset_postdata();

	return $query;
}

function stm_user_pay_per_multilistings_query(
	$user_id,
	$status = 'publish',
	$post_type = 'listings',
	$per_page = - 1,
	$popular = false,
	$offset = 0,
	$data_desc = false
) {
	$args = array(
		'post_type'      => $post_type,
		'post_status'    => $status,
		'posts_per_page' => $per_page,
		'offset'         => $offset,
		'meta_query'     => array(
			'relation' => 'AND',
			array(
				'key'     => 'stm_car_user',
				'value'   => $user_id,
				'compare' => '=',
			),
			array(
				'key'     => 'pay_per_listing',
				'compare' => '=',
				'value'   => 'pay',
			),
		),
	);

	if ( $popular ) {
		$args['order']   = 'ASC';
		$args['orderby'] = 'stm_car_views';
	}

	$query = new WP_Query( $args );
	wp_reset_postdata();

	return $query;

}

function stm_multilisting_get_type_icon_by_slug( $slug ) {
	$options = get_option( 'stm_motors_listing_types' );

	if ( isset( $options['multilisting_repeater'] ) && ! empty( $options['multilisting_repeater'] ) ) {
		foreach ( $options['multilisting_repeater'] as $key => $item ) {
			if ( $item['slug'] === $slug ) {
				return $options['multilisting_repeater'][ $key ]['icon']['icon'];
			}
		}
	}

	return 'fas fa-car-alt';
}

// multilisting after post/page save
add_action( 'save_post', 'stm_multilisting_after_post_save', 150, 3 );
function stm_multilisting_after_post_save( $post_id, $post, $updated ) {
	$types = apply_filters( 'stm_listings_multi_type', array() );
	if ( ! empty( $types ) && in_array( $post->post_type, $types, true ) ) {
		if ( isset( $_POST[ 'butterbean_' . $post->post_type . '_manager_setting_gallery' ] ) && ! empty( $_POST[ 'butterbean_' . $post->post_type . '_manager_setting_gallery' ] ) ) {//phpcs:ignore
			$attachment_ids = $_POST[ 'butterbean_' . $post->post_type . '_manager_setting_gallery' ]; //phpcs:ignore
			$exploded       = explode( ',', $attachment_ids );
			if ( is_array( $exploded ) && count( $exploded ) > 0 ) {
				$image_set = false;
				foreach ( $exploded as $img ) {
					if ( ! empty( $img ) && false === $image_set ) {
						set_post_thumbnail( $post_id, $img );
						$image_set = true;
					}
				}
			} else {
				delete_post_thumbnail( $post_id );
			}
		}
	}

	// listing type inventory details
	if ( preg_match( '/stm_listing_types_classic_filter/', $post->post_content, $match ) ) {
		preg_match_all( '/quant_listing_on_grid="(.*?)"/', $post->post_content, $quant_grid_items );
		preg_match_all( '/ppp_on_list="(.*?)"/', $post->post_content, $ppp_on_list );
		preg_match_all( '/ppp_on_grid="(.*?)"/', $post->post_content, $ppp_on_grid );

		update_post_meta( $post_id, 'quant_grid_items', ( ! empty( $quant_grid_items[1][0] ) ) ? $quant_grid_items[1][0] : 3 );
		update_post_meta( $post_id, 'ppp_on_list', ( ! empty( $ppp_on_list[1][0] ) ) ? $ppp_on_list[1][0] : 10 );
		update_post_meta( $post_id, 'ppp_on_grid', ( ! empty( $ppp_on_grid[1][0] ) ) ? $ppp_on_grid[1][0] : 9 );
	}
}

// override repeater script to make it collapsible
add_filter( 'wpcfto_field_repeater', 'multilisting_override_nuxy_repeater', 15 );
function multilisting_override_nuxy_repeater( $template ) {
	if (
		isset( $_GET['page'] ) && $_GET['page'] == 'stm_motors_listing_types' && //phpcs:ignore
		(
			apply_filters( 'stm_is_layout', 'listing_five' ) ||
			apply_filters( 'stm_is_layout', 'listing_four' ) ||
			apply_filters( 'stm_is_layout', 'listing_three' ) ||
			apply_filters( 'stm_is_layout', 'listing_two' ) ||
			apply_filters( 'stm_is_layout', 'listing' ) ||
			apply_filters( 'stm_is_layout', 'listing_five_elementor' ) ||
			apply_filters( 'stm_is_layout', 'listing_four_elementor' ) ||
			apply_filters( 'stm_is_layout', 'listing_three_elementor' ) ||
			apply_filters( 'stm_is_layout', 'listing_two_elementor' ) ||
			apply_filters( 'stm_is_layout', 'listing_one_elementor' )
		)
	) {
		return MULTILISTING_PATH . '/templates/nuxy/metaboxes/fields/repeater.php';
	}

	return $template;
}

// inventory filter post type hidden input
add_action( 'stm_listings_filter_after', 'multilisting_post_type_filter_after' );
function multilisting_post_type_filter_after() {
	$post_type = STMMultiListing::stm_get_current_listing_slug();
	if ( ! empty( $post_type ) ) {
		echo '<input type="hidden" name="posttype" value="' . esc_attr( $post_type ) . '" />';
	}
}

// imitate stm listings single body class
add_filter(
	'body_class',
	function ( $classes ) {
		$slugs = STMMultiListing::stm_get_listing_type_slugs();
		if ( is_singular( $slugs ) && ! in_array( 'single-listings', $classes, true ) ) {
			$classes = array_merge( $classes, array( 'single-listings' ) );
		}

		array_push( $classes, 'stm_motors_listing_types_multilisting_active' );

		return $classes;
	}
);

// load multilisting template
function stm_multilisting_load_template( $template, $vars = array() ) {
	extract( $vars );//phpcs:ignore

	if ( substr( $template, - 4 ) !== '.php' ) {
		$template .= '.php';
	}

	$template_path = apply_filters( 'stm_multilisting_template_path', MULTILISTING_PATH . $template, $template );

	include $template_path;
}

add_action( 'stm_multilisting_load_template', 'stm_multilisting_load_template', 10, 2 );

// include multilisting options for tax binding
add_action(
	'init',
	function () {
		add_filter( 'stm_include_multilisting_options', 'stm_multilisting_include_multilisting_options' );
	}
);

function stm_multilisting_include_multilisting_options( $options ) {
	if ( stm_is_multilisting() ) {
		$slugs = apply_filters( 'stm_listings_multi_type', array( 'listings' ) );

		if ( ! empty( $slugs ) ) {
			foreach ( $slugs as $slug ) {
				$type_options = (array) get_option( "stm_{$slug}_options", array() );

				if ( ! empty( $type_options ) ) {
					$options = array_merge( $options, $type_options );
				}
			}
		}
	}

	return $options;
}


// listing types js vars in admin
add_action( 'admin_footer', 'stm_multilisting_admin_js_vars' );
function stm_multilisting_admin_js_vars() {
	if ( isset( $_GET['post'] ) && ! empty( $_GET['post'] ) ) {//phpcs:ignore
		$types = apply_filters( 'stm_listings_multi_type', array( 'listings' ) );

		if ( ! empty( $types ) ) :
			?>
			<script>
                var multilisting_types_admin_js = <?php echo wp_json_encode( $types );//phpcs:ignore ?>;
                var multilisting_current_type_admin_js = '<?php echo get_post_type( $_GET['post'] );//phpcs:ignore ?>';
			</script>
			<?php
		endif;
	}
}

add_filter( 'stm_get_multilisting_types', 'stm_get_multilisting_types' );
function stm_get_multilisting_types() {
	$result = apply_filters( 'stm_listings_post_type', 'listings' );
	$option = get_option( 'stm_motors_listing_types' );

	if ( ! empty( $option ) && ! empty( $option['multilisting_repeater'] ) && is_array( $option['multilisting_repeater'] ) ) {
		$result   = array();
		$result[] = apply_filters( 'stm_listings_post_type', 'listings' );
		foreach ( $option['multilisting_repeater'] as $type ) {
			if ( ! empty( $type['slug'] ) ) {
				$result[] = $type['slug'];
			}
		}
	}

	return $result;
}

function sellers_note_migration() {
	$post_types = apply_filters( 'stm_listings_multi_type', array( '' ) );
	if ( false !== array_search( 'listings', $post_types, true ) ) {
		$key = array_search( 'listings', $post_types, true );
		unset( $post_types[ $key ] );
		$post_types = array_values( $post_types );
	}

	if ( empty( $post_types ) || get_option( 'sellers_note_migration_done' ) ) {
		return;
	}

	global $wpdb;

	foreach ( $post_types as $post_type ) {
		$posts = $wpdb->get_results(
			$wpdb->prepare(
				"SELECT ID FROM {$wpdb->posts} WHERE post_type = %s AND (post_content IS NULL OR post_content = '')",
				$post_type
			)
		);

		if ( ! empty( $posts ) ) {
			foreach ( $posts as $post ) {
				$seller_note = get_post_meta( $post->ID, 'listing_seller_note', true );
				if ( ! empty( $seller_note ) && empty( $post->post_content ) ) {
					$wpdb->update(
						$wpdb->posts,
						array( 'post_content' => $seller_note ),
						array( 'ID' => $post->ID ),
						array( '%s' ),
						array( '%d' )
					);
				}
			}
		}
	}
	update_option( 'sellers_note_migration_done', true );
}

add_action( 'admin_init', 'sellers_note_migration' );
