<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

new STMMultiListing();

class STMMultiListing {

	protected $listings = array();

	public function __construct() {
		$this->listings = $this->stm_get_listings();
	}

	public static function stm_get_listings() {
		$options = get_option( 'stm_motors_listing_types', array() );

		if ( isset( $options['multilisting_repeater'] ) && ! empty( $options['multilisting_repeater'] ) ) {
			return $options['multilisting_repeater'];
		}

		return array();
	}

	public function get_post_type() {
		global $wp_query;

		if ( ! $wp_query ) {
			return false;
		}

		if ( ! empty( $_REQUEST['posttype'] ) ) {
			$post_type = sanitize_text_field( $_REQUEST['posttype'] );
		} else {
			$post_type = ! empty( $wp_query->get( 'listings_type' ) ) ? $wp_query->get( 'listings_type' ) : get_post_type();
		}

		$slugs = $this->stm_get_listing_type_slugs();
		if ( is_post_type_archive( $slugs ) && ! empty( get_queried_object()->name ) && in_array( strtolower( get_queried_object()->name ), $slugs, true ) ) {
			$post_type = get_queried_object()->name;
		}

		return $post_type;
	}

	public function get_current_post_type( $slug = '' ) {
		$listing = array();

		if ( empty( $slug ) ) {
			$slug = $this->get_post_type();
		}

		if ( ! empty( $this->listings ) ) {
			$listings = wp_list_filter( $this->listings, array( 'slug' => $slug ) );

			if ( ! empty( $listings ) ) {
				$listing = reset( $listings );
			}
		}

		return $listing;
	}

	public function stm_get_current_listing() {
		if ( is_admin() ) {
			return false;
		}

		global $wp_query;

		if ( ! $wp_query ) {
			return false;
		}

		$post_type = $this->get_post_type();

		if ( $post_type && ! empty( $this->listings ) ) {
			$listings = wp_list_filter( $this->listings, array( 'slug' => $post_type ) );

			return reset( $listings );
		}

		return false;
	}

	public static function stm_get_current_listing_slug() {
		$multi_listing = new STMMultiListing();
		$current       = $multi_listing->stm_get_current_listing();

		if ( is_array( $current ) && isset( $current['slug'] ) ) {
			return $current['slug'];
		}

		return false;
	}

	public function stm_get_listing_name_by_slug( $slug = '' ) {
		$label = '';

		if ( ! empty( $this->listings ) ) {
			$listing = $this->get_current_post_type( $slug );

			if ( ! empty( $listing ) ) {
				$label = $listing['label'];
			}
		}

		return $label;
	}

	protected function register_listings( $listing ) {
		register_post_type(
			$listing['slug'],
			array(
				'labels'             => array(
					'name'               => apply_filters( 'wpml_translate_single_string', $listing['label'], 'motors_listing_types', $listing['label'] ),
					'singular_name'      => apply_filters( 'wpml_translate_single_string', $listing['label'], 'motors_listing_types', $listing['label'] ),
					'add_new'            => __( 'Add New', 'motors_listing_types' ),
					'add_new_item'       => __( 'Add New Item', 'motors_listing_types' ),
					'edit_item'          => __( 'Edit Item', 'motors_listing_types' ),
					'new_item'           => __( 'New Item', 'motors_listing_types' ),
					'all_items'          => __( 'All Items', 'motors_listing_types' ),
					'view_item'          => __( 'View Item', 'motors_listing_types' ),
					'search_items'       => __( 'Search Items', 'motors_listing_types' ),
					'not_found'          => __( 'No items found', 'motors_listing_types' ),
					'not_found_in_trash' => __( 'No items found in Trash', 'motors_listing_types' ),
					'parent_item_colon'  => '',
					'menu_name'          => apply_filters( 'wpml_translate_single_string', $listing['label'], 'motors_listing_types', $listing['label'] ),
				),
				'menu_icon'          => 'dashicons-location-alt',
				'show_in_nav_menus'  => true,
				'supports'           => array( 'title', 'editor', 'thumbnail', 'comments', 'excerpt', 'author', 'revisions' ),
				'rewrite'            => array( 'slug' => $listing['slug'] ),
				'has_archive'        => true,
				'public'             => true,
				'publicly_queryable' => true,
				'show_ui'            => true,
				'show_in_menu'       => true,
				'query_var'          => true,
				'hierarchical'       => false,
				'menu_position'      => 4,
			)
		);
	}

	public function stm_register_post_types() {
		if ( is_array( $this->listings ) && count( $this->listings ) ) {
			foreach ( $this->listings as $listing ) {
				if ( empty( $listing['slug'] ) || empty( $listing['label'] ) ) {
					return;
				}
				if ( post_type_exists( $listing['slug'] ) ) {
					continue;
				}

				$this->register_listings( $listing );
			}
		}
	}

	protected function stm_save_post_type_options( $listing, $options ) {
		$settings = stm_listings_page_options();

		foreach ( $options as $key => $option ) {
			foreach ( $option as $name => $item ) {
				if ( 'checkbox' === $settings[ $name ]['type'] && ! empty( $item ) ) {
					$options[ $key ][ $name ] = 1;
				}
			}
		}

		if ( current_user_can( 'administrator' ) || current_user_can( 'editor' ) ) {
			update_option( 'stm_' . $listing['slug'] . '_options', $options );
		}
	}

	public static function stm_get_listing_type_slugs(): array {
		$slugs    = array();
		$listings = self::stm_get_listings();

		if ( ! empty( $listings ) ) {
			$slugs = wp_list_pluck( $listings, 'slug' );
		}

		return $slugs;
	}

	public function stm_get_listing_type_settings( $setting_name, $slug ) {
		$options = get_option( 'stm_motors_listing_types', array() );

		if ( isset( $options[ $slug . '_' . $setting_name ] ) && ! empty( $options[ $slug . '_' . $setting_name ] ) ) {
			return $options[ $slug . '_' . $setting_name ];
		}

		return false;
	}

}
