<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Eikra_Core;
use Elementor\Icons_Manager;
?>
<div class="rt-marquee-slider">
	<div class="rt-marquee <?php echo esc_attr( ! empty( $data['marquee_direction'] ) ? $data['marquee_direction'] : '' );?>">
		<div class="rt-marquee-item">
			<?php
			// Safety: ensure slides exist
			if ( ! empty( $data['marquee_slide'] ) && is_array( $data['marquee_slide'] ) ) :
				foreach ( $data['marquee_slide'] as $marquee_slides ) :
					$attr = '';
					if ( ! empty( $marquee_slides['url']['url'] ) ) {
						$attr  = 'href="' . esc_url( $marquee_slides['url']['url'] ) . '"';
						$attr .= ! empty( $marquee_slides['url']['is_external'] ) ? ' target="_blank"' : '';
						$attr .= ! empty( $marquee_slides['url']['nofollow'] ) ? ' rel="nofollow"' : '';
						$title = '<a ' . $attr . '>' . esc_html( $marquee_slides['title'] ) . '</a>';
					} else {
						$title = esc_html( $marquee_slides['title'] );
					}
					$heading_tag = ! empty( $data['heading_size'] ) ? esc_attr( $data['heading_size'] ) : 'h3';
				?>
				<<?php echo $heading_tag; ?> class="entry-title">
					<span>
						<?php
						// Use the slide's image key (if provided). Accept ['image']['id'] or ['image']['url']
						if ( ! empty( $marquee_slides['image'] ) && is_array( $marquee_slides['image'] ) ) {
							if ( ! empty( $marquee_slides['image']['id'] ) ) {
								echo wp_get_attachment_image( intval( $marquee_slides['image']['id'] ), 'full' );
							} elseif ( ! empty( $marquee_slides['image']['url'] ) ) {
								echo '<img src="' . esc_url( $marquee_slides['image']['url'] ) . '" alt="' . esc_attr( $marquee_slides['title'] ) . '" />';
							}
						}
						?>
					</span>
					<?php echo wp_kses_post( $title );?>
				</<?php echo $heading_tag; ?>>
			<?php
				endforeach;
			endif;
			?>
		</div>
		<div class="rt-marquee-item">
			<?php
			if ( ! empty( $data['marquee_slide'] ) && is_array( $data['marquee_slide'] ) ) :
				foreach ( $data['marquee_slide'] as $marquee_slides ) :
					$attr = '';
					if ( ! empty( $marquee_slides['url']['url'] ) ) {
						$attr  = 'href="' . esc_url( $marquee_slides['url']['url'] ) . '"';
						$attr .= ! empty( $marquee_slides['url']['is_external'] ) ? ' target="_blank"' : '';
						$attr .= ! empty( $marquee_slides['url']['nofollow'] ) ? ' rel="nofollow"' : '';
						$title = '<a ' . $attr . '>' . esc_html( $marquee_slides['title'] ) . '</a>';
					} else {
						$title = esc_html( $marquee_slides['title'] );
					}
					$heading_tag = ! empty( $data['heading_size'] ) ? esc_attr( $data['heading_size'] ) : 'h3';
				?>
				<<?php echo $heading_tag; ?> class="entry-title">
					<span>
						<?php
						if ( ! empty( $marquee_slides['image'] ) && is_array( $marquee_slides['image'] ) ) {
							if ( ! empty( $marquee_slides['image']['id'] ) ) {
								echo wp_get_attachment_image( intval( $marquee_slides['image']['id'] ), 'full' );
							} elseif ( ! empty( $marquee_slides['image']['url'] ) ) {
								echo '<img src="' . esc_url( $marquee_slides['image']['url'] ) . '" alt="' . esc_attr( $marquee_slides['title'] ) . '" />';
							}
						}
						?>
					</span>
					<?php echo wp_kses_post( $title );?>
				</<?php echo $heading_tag; ?>>
			<?php
				endforeach;
			endif;
			?>
		</div>
	</div>
</div>