<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.7
 */

$query = new WP_query( $data['event_args'] );



?>
<div class="rt-vc-event rt-vc-event-grid-2 rt-event-block-wrapper">
	<?php if ( $query->have_posts() ): ?>
        <div class="row auto-clear">
			<?php while ( $query->have_posts() ): $query->the_post(); ?>
				<?php
				$id         = get_the_ID();
				$start_date = get_post_meta( $id, 'ac_event_start_date', true );
				$end_date   = get_post_meta( $id, 'ac_event_end_date', true );
				$start_time = get_post_meta( $id, 'ac_event_start_time', true );
				$end_time   = get_post_meta( $id, 'ac_event_end_time', true );
				$location   = get_post_meta( $id, 'ac_event_location', true );
				$content    = get_the_content();
				$content    = RDTheme_Helper::filter_content( $content );
				$content    = wp_trim_words( $content, $data['length'] );

				// Format date parts as numeric day/month/year (e.g. 09/12/2023)
				if ( ! empty( $start_date ) ) {
					$day   = date_i18n( 'd', strtotime( $start_date ) );
					$month = date_i18n( 'm', strtotime( $start_date ) );
					$year  = date_i18n( 'Y', strtotime( $start_date ) );
				} else {
					$day = $month = $year = '';
				}
				$event_time = "<span class='time-range'>";
				$event_time .= $start_time ? "<span>{$start_time}</span>" : null;
				$event_time .= $end_time ? "<span>{$end_time}</span>" : null;
				$event_time .= "</span>";
				if ( $start_date != $end_date ) {
					$event_time .= "({$end_date})";
				}

				?>
                <div class="col-lg-4 col-md-6 col-xs-12">
                       <div class="rtin-item">
	                    <?php if ( has_post_thumbnail( $id ) ): ?>
                            <div class="rtin-thumb">
                                <?php echo get_the_post_thumbnail( $id, 'full' ); ?>
                                <div class="rt-date-format">
                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M10.6611 0.549805V3.34983M4.43887 0.549805V3.34983M0.549988 6.14972H14.55M2.10554 1.94968H12.9944C13.8535 1.94968 14.55 2.57649 14.55 3.3497V13.1498C14.55 13.923 13.8535 14.5498 12.9944 14.5498H2.10554C1.24643 14.5498 0.549988 13.923 0.549988 13.1498V3.3497C0.549988 2.57649 1.24643 1.94968 2.10554 1.94968Z" stroke="currentColor" stroke-width="1.1" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
		                            <?php echo esc_html( $day . '/' . $month . '/' . $year ); ?>
                                </div>
                            </div>
	                    <?php endif; ?>

                        <div class="rt-event-content">
                            <h3 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
	                        <?php if ( $location ): ?>
                                <div class="rtin-location">
                                    <svg width="15" height="18" viewBox="0 0 15 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M13.65 7.19536C13.65 12.2863 7.14999 16.6499 7.14999 16.6499C7.14999 16.6499 0.649994 12.2863 0.649994 7.19536C0.649994 5.45939 1.33481 3.79453 2.5538 2.56702C3.77279 1.33951 5.42609 0.649902 7.14999 0.649902C8.8739 0.649902 10.5272 1.33951 11.7462 2.56702C12.9652 3.79453 13.65 5.45939 13.65 7.19536Z" stroke="currentColor" stroke-width="1.3" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M7.14999 9.37718C8.34661 9.37718 9.31666 8.40034 9.31666 7.19536C9.31666 5.99037 8.34661 5.01354 7.14999 5.01354C5.95338 5.01354 4.98333 5.99037 4.98333 7.19536C4.98333 8.40034 5.95338 9.37718 7.14999 9.37718Z" stroke="currentColor" stroke-width="1.3" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
	                                <?php echo esc_html( $location ); ?></div>
	                        <?php endif; ?>
                        </div>
                    </div>
                </div>
			<?php endwhile; ?>
			<?php if ( $data['pagination'] == 'yes' ): ?>
                <div class="col-sm-12 col-xs-12 mt30"><?php echo RDTheme_Helper::list_posts_pagination( $query ); ?></div>
			<?php endif; ?>
        </div>
	<?php else: ?>
        <div class="media rtin-item"><?php esc_html_e( 'No Events Available', 'eikra-core' ); ?></div>
	<?php endif; ?>
	<?php wp_reset_query(); ?>
</div>