<?php
/**
 * Course Category view template
 * Renders course categories according to widget settings in $data
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
use Elementor\Icons_Manager;
// Normalize settings with sensible defaults
$style          = isset( $data['style'] ) ? $data['style'] : '1';
$animationOn    = ( isset( $data['animation'] ) && $data['animation'] === 'wow' );
$animationCls   = $animationOn ? 'wow' : '';
$animationEffect = isset( $data['animation_effect'] ) ? $data['animation_effect'] : '';
$delay          = isset( $data['delay'] ) ? $data['delay'] : '0';
$duration       = isset( $data['duration'] ) ? $data['duration'] : '1';
$icon_display   = ( isset( $data['icon_display'] ) && $data['icon_display'] === 'yes' );
$icontype       = isset( $data['icontype'] ) ? $data['icontype'] : 'icon';
$icon_data      = isset( $data['icon_class'] ) ? $data['icon_class'] : '';
$icon_image_url = '';
if ( isset( $data['icon_image'] ) && is_array( $data['icon_image'] ) && ! empty( $data['icon_image']['url'] ) ) {
    $icon_image_url = $data['icon_image']['url'];
}
$shape_display  = ( isset( $data['arrow_icon_display'] ) && $data['arrow_icon_display'] === 'yes' );
$cat_num_display = ( isset( $data['cat_num_display'] ) && $data['cat_num_display'] === 'yes' );



// Determine which categories to show
$terms_args = array(
    'taxonomy'   => 'course_category',
    'hide_empty' => false,
);
if ( isset( $data['cat'] ) && ! empty( $data['cat'] ) && $data['cat'] !== '0' ) {
    // Accept single id or array
    $terms_args['include'] = (array) $data['cat'];
}

$terms = get_terms( $terms_args );
if ( is_wp_error( $terms ) || empty( $terms ) ) {
    // Nothing to render
    return;
}

// Optional limit
if ( isset( $data['item_no'] ) && intval( $data['item_no'] ) > 0 ) {
    $terms = array_slice( $terms, 0, intval( $data['item_no'] ) );
}

// Assets URL fallback
$assets_base = defined( 'QUIKLEARN_ASSETS_URL' ) ? QUIKLEARN_ASSETS_URL : plugin_dir_url( __FILE__ ) . '../../assets/';

// Begin output
foreach ( $terms as $course_category ) :
    $term_link = get_term_link( $course_category );
    if ( is_wp_error( $term_link ) ) {
        $term_link = '#';
    }

    // Prepare icon/html
    $getimg = '';
    if ( $icon_image_url ) {
        $getimg = '<img src="' . esc_url( $icon_image_url ) . '" alt="' . esc_attr( $course_category->name ) . '" />';
    }

    // Dynamic cat_icon (new control) — may be array or string
    $cat_icon = isset( $data['cat_icon'] ) ? $data['cat_icon'] : null;

    ?>

    <div class="rt-course-category rt-course-cat-<?php echo esc_attr( $style ); ?>">
        <div class="rt-cat-item <?php echo esc_attr( $animationCls ); ?> <?php echo esc_attr( $animationEffect ); ?>" data-wow-delay="<?php echo esc_attr( $delay ); ?>s" data-wow-duration="<?php echo esc_attr( $duration ); ?>s">
            <div class="rt-cat-inner">
                <?php if ( $icon_display ): ?>
                    <div class="rt-media">
                        <?php if ( $icontype === 'image' ) : ?>
                            <span class="rt-img"><?php echo wp_kses_post( $getimg ); ?></span>
                        <?php endif; ?>
	                    <?php if (
                            ! empty( $data['cat_icon'] ) &&
                            Icons_Manager::is_migration_allowed()
                        ) :
                        ?>
                        <span class="rt-icon">
                            <?php
                            Icons_Manager::render_icon(
                                $data['cat_icon'],
                                [ 'aria-hidden' => 'true' ]
                            );
                            ?>
                        </span>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                <div class="rt-course-cat">
                    <?php if ( ! empty( $course_category ) ) : ?>
                        <h3 class="rt-cat-title"><a href="<?php echo esc_url( $term_link ); ?>"><?php echo esc_html( $course_category->name ); ?></a></h3>

                        <?php if ( $cat_num_display ) :
                            $course_cat_text = _n( ' course', ' courses', intval( $course_category->count ), 'quiklearn-core' );
                        ?>
                            <span class="rt-course-count"><?php echo esc_html( $course_category->count ) . esc_html( $course_cat_text ); ?></span>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>

            <?php if ( $shape_display ) : ?>
                <div class="course-content-shape">
                    <a href="<?php echo esc_url( $term_link ); ?>">
                        <svg width="26" height="16" viewBox="0 0 26 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M0.900024 7.90002H24.9M24.9 7.90002L17.9 0.900024M24.9 7.90002L17.9 14.9" stroke="#7A7A7A" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </a>
                </div>
            <?php endif; ?>

        </div>
    </div>

<?php
endforeach;

// End of template
