<?php

/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
$rdtheme_socials = RDTheme_Helper::socials();
?>

<div class="rt-topbar-8" id="tophead">
    <div class="container">
        <div class="row">
            <div class="col-sm-12 d-flex align-items-center">
                <div class="tophead-contact">
                    <ul>
						<?php if ( RDTheme::$options['address'] ): ?>
                            <li>
                                <i class="fas fa-map"></i>
								<?php echo esc_html( RDTheme::$options['address'] ); ?>
                            </li>
						<?php endif; ?>

						<?php if ( RDTheme::$options['email'] ): ?>
                            <li>
                                <i class="far fa-envelope"></i>
                                <a href="mailto:<?php echo esc_attr( RDTheme::$options['email'] ); ?>">
									<?php echo esc_html( RDTheme::$options['email'] ); ?>
                                </a>
                            </li>
						<?php endif; ?>
                    </ul>
                </div>
                <div class="tophead-right ml-auto">

	                <?php if ( RDTheme::$options['phone'] ): ?>
                        <div class="rt-phone">
                            <i class="fas fa-phone-alt" aria-hidden="true"></i><a
                                    href="tel:<?php echo esc_attr( RDTheme::$options['phone'] ); ?>"><?php echo esc_html( RDTheme::$options['phone'] ); ?></a>
                        </div>
	                <?php endif; ?>

                    <div class="topbar-social">
						<?php if ( $rdtheme_socials ): ?>
                            <ul class="header-social">
								<?php foreach ( $rdtheme_socials as $rdtheme_social ): ?>
                                    <li><a target="_blank" href="<?php echo esc_url( $rdtheme_social['url'] ); ?>"><i
                                                    class="<?php echo esc_attr( $rdtheme_social['icon'] ); ?>"></i></a></li>
								<?php endforeach; ?>
                            </ul>
						<?php endif; ?>
                    </div>

                </div>
                <div class="clear"></div>
            </div>
        </div>
    </div>
</div>