<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$nav_menu_args = RDTheme_Helper::nav_menu_args();

$rdtheme_logo_width = (int) RDTheme::$options['logo_width'];
$rdtheme_menu_width = 12 - $rdtheme_logo_width;
$rdtheme_logo_class = "col-sm-{$rdtheme_logo_width} col-xs-12";
$rdtheme_menu_class = "col-sm-{$rdtheme_menu_width} col-xs-12";

?>
<div class="container masthead-container">
    <div class="row menu-flex-wrapper">

        <!--site logo-->
        <div class="site-logo-section">
            <div class="site-branding">
	            <?php echo RDTheme_Helper::get_site_logo(); ?>
            </div>
        </div>
        <!--end site logo-->

        <!--site menu -->
        <div class="site-menu-section">
            <div id="site-navigation" class="main-navigation">
				<?php wp_nav_menu( $nav_menu_args ); ?>
            </div>
        </div>

        <div class="header-icon-area">
            <?php if ( RDTheme::$options['search_icon'] ) {
                get_template_part( 'template-parts/header/icon', 'search' );
            }
		    if ( RDTheme::$options['cart_icon'] && class_exists( 'WC_Widget_Cart' ) ) {
			    get_template_part( 'template-parts/header/icon', 'cart' );
		    }
            $user_login_label = is_user_logged_in() ? 'Lig in' : 'Login / Register'; ?>
            <div class="login-btn">
                <a href="<?php echo esc_url( wp_login_url() ) ?>">
			        <?php echo esc_html__( $user_login_label, 'eikra' ) ?>
                </a>
            </div>

            <?php if ( RDTheme::$options['vertical_menu_icon'] && has_nav_menu( 'topright' ) && '8' != RDTheme::$header_style ){
			    get_template_part( 'template-parts/header/icon', 'menu' );
		    }
		    ?>
        </div>
        <!--end site menu -->

    </div>
</div>