<?php

/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.3
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$rdtheme_footer_column = RDTheme::$options['footer_column'];
switch ( $rdtheme_footer_column ) {
	case '1':
		$rdtheme_footer_class = 'col-sm-12 col-12';
		break;
	case '2':
		$rdtheme_footer_class = 'col-md-6 col-sm-12 col-12';
		break;
	case '3':
		$rdtheme_footer_class = 'col-md-4 col-sm-12 col-12';
		break;
	default:
		$rdtheme_footer_class = 'col-lg-3 col-md-6 col-12';
		break;
}
$rdtheme_copyright_class = RDTheme::$options['payment_icons'] ? 'col-sm-8 col-xs-12' : 'col-sm-12 col-xs-12 text-center';
$rdtheme_socials = RDTheme_Helper::socials();
?>
<footer class="site-footer-wrap">
	<?php if ( RDTheme_Helper::has_footer() ): ?>
        <div class="footer-top-area">
            <div class="container">
                <div class="row">
					<?php
					for ( $i = 1; $i <= $rdtheme_footer_column; $i ++ ) {
						echo '<div class="' . $rdtheme_footer_class . '">';
						dynamic_sidebar( 'footer-3-' . $i );
						echo '</div>';
					}
					?>
                </div>
            </div>
        </div>
	<?php endif; ?>
	<?php if ( RDTheme::$options['copyright_area'] ): ?>
        <div class="footer-bottom-area">
            <div class="container">
                <div class="row">

                    <div class="<?php echo esc_attr( $rdtheme_copyright_class ); ?>"><?php echo wp_kses_post( RDTheme::$options['copyright_text'] ); ?></div>

	                <?php if ( $rdtheme_socials ): ?>
                        <div class="col-sm-4 col-xs-12">
                            <ul class="footer-social">
		                        <?php foreach ( $rdtheme_socials as $rdtheme_social ): ?>
                                    <li><a target="_blank" href="<?php echo esc_url( $rdtheme_social['url'] );?>"><i class="<?php echo esc_attr( $rdtheme_social['icon'] );?>"></i></a></li>
		                        <?php endforeach; ?>
                            </ul>
                        </div>
					<?php endif; ?>
                </div>
            </div>
        </div>
	<?php endif; ?>
</footer>