<?php
/**
 * @author  RadiusTheme
 * @since   3.0
 * @version 3.3
 */

$rdtheme_thumbnail = ! empty( $rdtheme_thumbnail ) ? $rdtheme_thumbnail : 'rdtheme-size2';

$rdtheme_id     = get_the_ID();
$rdtheme_course = LP_Global::course();

if ( empty( $rdtheme_course ) ) {
	return;
}

$rdtheme_author       = get_post_field( 'post_author', $rdtheme_id );
$rdtheme_enroll_count = $rdtheme_course->get_users_enrolled();
$rdtheme_enroll_count = $rdtheme_enroll_count ? $rdtheme_enroll_count : 0;

if ( function_exists( 'learn_press_get_course_rate' ) ) {
	$course_rate_res = learn_press_get_course_rate( $rdtheme_id, false );
	$course_rate     = $course_rate_res['rated'];
}
?>
<div <?php post_class( 'rt-course-box-6 rt-course-box-5' ); ?>>
	<?php do_action( 'learn_press_before_courses_loop_item' ); ?>
    <div class="rtin-thumbnail">
        <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_post_thumbnail( $rdtheme_thumbnail ); ?></a>
	    <?php
	    $image_id = get_post_meta( get_the_ID(), '_lp_flag_image_id', true );
	    if ( $image_id ) {
		    echo "<div class='lp-icon-flag'>";
		    echo wp_get_attachment_image( $image_id, 'large', false, [
			    'class' => 'lp-custom-image'
		    ]);
		    echo "</div>";
	    }
        ?>
    </div>
    <div class="rtin-content-wrap">
        <div class="rtin-content">
            <h3 class="rtin-title"><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h3>
            <?php // Course total Curriculum ?>
            <?php
            // Show curriculum summary: lectures and quizzes counts
            if ( ! empty( $rdtheme_course ) ) {
                $lecture_items = $rdtheme_course->get_curriculum_items( 'lp_lesson' );
                $lecture_count = $lecture_items ? count( $lecture_items ) : 0;
            }
            ?>
            <div class="rt-student-inner">
	            <?php if ( RDTheme::$options['course_archive_enroll_visibility'] ) : ?>
                    <div class="rtin-enroll-num">
                        <svg width="17" height="13" viewBox="0 0 17 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M5.75175 6.08228C6.37516 6.08228 6.98458 5.9039 7.50292 5.56972C8.02126 5.23553 8.42524 4.76054 8.66379 4.20481C8.90233 3.64908 8.96472 3.03758 8.84306 2.44765C8.7214 1.85771 8.42115 1.31583 7.98029 0.890542C7.53944 0.465252 6.97777 0.175654 6.36632 0.0583712C5.75487 -0.0589117 5.12111 0.00138869 4.54519 0.231647C3.96926 0.461905 3.47704 0.851778 3.13077 1.35196C2.7845 1.85214 2.59973 2.44017 2.59984 3.04167C2.60072 3.84792 2.93309 4.6209 3.52402 5.19096C4.11494 5.76101 4.91613 6.08157 5.75175 6.08228Z" fill="#A6A6A6"/>
                            <path d="M9.87488 8.59447C9.07619 7.80404 8.05142 7.26126 6.93147 7.03548C5.81152 6.80969 4.64724 6.91115 3.58734 7.32689C2.52745 7.74263 1.62005 8.45378 0.981067 9.3695C0.342083 10.2852 0.000516982 11.3639 0 12.4679C0 12.609 0.0581059 12.7443 0.161535 12.8441C0.264964 12.9439 0.405244 13 0.551515 13H10.9531C11.0994 13 11.2396 12.9439 11.3431 12.8441C11.4465 12.7443 11.5046 12.609 11.5046 12.4679C11.5067 11.9036 11.4165 11.3426 11.2371 10.8055C10.9701 9.97515 10.5033 9.21753 9.87488 8.59447Z" fill="#A6A6A6"/>
                            <path d="M12.4091 6.34834C13.7036 6.34834 14.753 5.33581 14.753 4.08678C14.753 2.83775 13.7036 1.82522 12.4091 1.82522C11.1146 1.82522 10.0652 2.83775 10.0652 4.08678C10.0652 5.33581 11.1146 6.34834 12.4091 6.34834Z" fill="#A6A6A6"/>
                            <path d="M12.4091 6.97094C11.6698 6.97362 10.9449 7.16788 10.31 7.5334C10.4297 7.63664 10.5505 7.73827 10.6635 7.85002C11.4145 8.59477 11.9724 9.50024 12.2916 10.4926C12.401 10.8193 12.4816 11.1543 12.5326 11.4941H15.9939C16.1402 11.4941 16.2805 11.438 16.3839 11.3382C16.4873 11.2384 16.5455 11.1031 16.5455 10.9619C16.5443 9.9038 16.1081 8.88933 15.3327 8.14112C14.5572 7.39291 13.5058 6.97207 12.4091 6.97094Z" fill="#A6A6A6"/>
                        </svg>
                        <span><?php echo esc_html( $rdtheme_enroll_count ); ?></span>
                    </div>
	            <?php endif; ?>
	            <?php if ( ! empty( $lecture_count ) && ! empty( RDTheme::$options['course_meta']['lec'] ) ) : ?>
                    <div class="rt-course-lectures"><i class="fas fa-book" aria-hidden="true"></i> <?php echo esc_html( $lecture_count ); ?> <?php esc_html_e( 'Lectures', 'eikra' ); ?></div>
	            <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="clear"></div>
	<?php do_action( 'learn_press_after_courses_loop_item' ); ?>
</div>