<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 3.5
 */

if ( ! class_exists( 'Redux' ) ) {
	return;
}

$opt_name = "eikra";

$theme = wp_get_theme();
$args  = [
	// TYPICAL -> Change these values as you need/desire
	'opt_name'             => $opt_name,
	// This is where your data is stored in the database and also becomes your global variable name.
	'disable_tracking'     => true,
	'display_name'         => $theme->get( 'Name' ),
	// Name that appears at the top of your panel
	'display_version'      => $theme->get( 'Version' ),
	// Version that appears at the top of your panel
	'menu_type'            => 'submenu',
	//Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
	'allow_sub_menu'       => true,
	// Show the sections below the admin menu item or not
	'menu_title'           => esc_html( 'Eikra Options' ),
	'page_title'           => esc_html( 'Eikra Options' ),
	// You will need to generate a Google API key to use this feature.
	// Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
	//'google_api_key'       => 'AIzaSyC2GwbfJvi-WnYpScCPBGIUyFZF97LI0xs',
	// Set it you want google fonts to update weekly. A google_api_key value is required.
	'google_update_weekly' => false,
	// Must be defined to add google fonts to the typography module
	'async_typography'     => true,
	// Use a asynchronous font on the front end or font string
	//'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
	'admin_bar'            => true,
	// Show the panel pages on the admin bar
	'admin_bar_icon'       => 'dashicons-menu',
	// Choose an icon for the admin bar menu
	'admin_bar_priority'   => 50,
	// Choose an priority for the admin bar menu
	'global_variable'      => '',
	// Set a different name for your global variable other than the opt_name
	'dev_mode'             => false,
	'forced_dev_mode_off'  => false,
	// Show the time the page took to load, etc
	'update_notice'        => false,
	// If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
	'customizer'           => true,
	// Enable basic customizer support
	//'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
	//'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

	// OPTIONAL -> Give you extra features
	'page_priority'        => null,
	// Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
	'page_parent'          => 'themes.php',
	// For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
	'page_permissions'     => 'manage_options',
	// Permissions needed to access the options panel.
	'menu_icon'            => '',
	// Specify a custom URL to an icon
	'last_tab'             => '',
	// Force your panel to always open to a specific tab (by id)
	'page_icon'            => 'icon-themes',
	// Icon displayed in the admin panel next to your menu_title
	'page_slug'            => 'eikra-options',
	// Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
	'save_defaults'        => true,
	// On load save the defaults to DB before user clicks save or not
	'default_show'         => true,
	// If true, shows the default value next to each field that is not the default value.
	'default_mark'         => '',
	// What to print by the field's title if the value shown is default. Suggested: *
	'show_import_export'   => true,
	// Shows the Import/Export panel when not used as a field.

	// CAREFUL -> These options are for advanced use only
	'transient_time'       => 60 * MINUTE_IN_SECONDS,
	'output'               => true,
	// Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
	'output_tag'           => true,
	// Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
	// 'footer_credit'     => '',
	// Disable the footer credit of Redux. Please leave if you can help it.

	// FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
	'database'             => '',
	// possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
	'use_cdn'              => true,
	// If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.
];

$args = apply_filters( 'rdtheme_redux_args', $args );

Redux::setArgs( $opt_name, $args );

// Fields
Redux::setSection( $opt_name,
	[
		'title'   => esc_html( 'General' ),
		'id'      => 'general_section',
		'heading' => '',
		'icon'    => 'el el-network',
		'fields'  => [
			[
				'id'          => 'primary_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Primary Color' ),
				'default'     => '#002147',
			],
			[
				'id'          => 'secondery_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Secondery/Hover Color' ),
				'default'     => '#fdc800',
			],
			[
				'id'      => 'preloader',
				'type'    => 'switch',
				'title'   => esc_html( 'Preloader' ),
				'on'      => esc_html( 'Enabled' ),
				'off'     => esc_html( 'Disabled' ),
				'default' => true,
			],
			[
				'id'       => 'preloader_image',
				'type'     => 'media',
				'title'    => esc_html( 'Preloader Image' ),
				'subtitle' => esc_html( 'Please upload your choice of preloader image. Transparent GIF format is recommended' ),
				'default'  => [
					'url' => RDTHEME_IMG_URL . 'preloader.gif',
				],
				'required' => [ 'preloader', 'equals', true ],
			],
			[
				'id'      => 'back_to_top',
				'type'    => 'switch',
				'title'   => esc_html( 'Back to Top Arrow' ),
				'on'      => esc_html( 'Enabled' ),
				'off'     => esc_html( 'Disabled' ),
				'default' => true,
			],
			[
				'id'       => 'no_preview_image',
				'type'     => 'media',
				'title'    => esc_html( 'Alternative Preview Image' ),
				'subtitle' => esc_html( 'This image will be used as preview image in some archive pages if no featured image exists' ),
				'default'  => [
					'url' => RDTHEME_IMG_URL . 'noimage.jpg',
				],
			],
			[
				'id'       => 'research_slug',
				'type'     => 'text',
				'title'    => esc_html( 'Research Slug' ),
				'subtitle' => esc_html( 'Will be used as slug in Research breadcrumb' ),
				'default'  => 'research',
			],
			[
				'id'       => 'event_slug',
				'type'     => 'text',
				'title'    => esc_html( 'Event Slug' ),
				'subtitle' => esc_html( 'Will be used as slug in Event breadcrumb' ),
				'default'  => 'event',
			],
			[
				'id'      => 'event_time_format',
				'type'    => 'radio',
				'title'   => __( 'Event Time Format' ),
				'options' => [
					'24' => __( '24-hour' ),
					'12' => __( '12-hour' ),
				],
				'default' => '24',
			],
			[
				'id'       => 'course_slug',
				'type'     => 'text',
				'class'    => RDTheme_Helper::is_LMS() ? 'hide' : '',
				'title'    => esc_html( 'Course Slug' ),
				'subtitle' => esc_html( 'Will be used as slug in Course breadcrumb' ),
				'default'  => 'courses',
			],
			[
				'id'       => 'instructor_slug',
				'type'     => 'text',
				'class'    => RDTheme_Helper::is_LMS() ? 'hide' : '',
				'title'    => esc_html( 'Instructor Slug' ),
				'subtitle' => esc_html( 'Will be used as slug in Instructor breadcrumb' ),
				'default'  => 'instructor',
			],
		],
	]
);

Redux::setSection( $opt_name,
	[
		'title'   => esc_html( 'Contact & Socials' ),
		'id'      => 'socials_section',
		'heading' => '',
		'desc'    => esc_html( 'In case you want to hide any field, just keep that field empty' ),
		'icon'    => 'el el-twitter',
		'fields'  => [
			[
				'id'      => 'phone',
				'type'    => 'text',
				'title'   => esc_html( 'Phone' ),
				'default' => '(+123) 2390 7000',
			],
			[
				'id'       => 'email',
				'type'     => 'text',
				'title'    => esc_html( 'Email' ),
				'validate' => 'email',
				'default'  => 'info@example.com',
			],
			[
				'id'      => 'address',
				'type'    => 'textarea',
				'title'   => esc_html( 'Address' ),
				'default' => '0123 Alaskan Way, Seattle, WA',
			],
			[
				'id'      => 'social_facebook',
				'type'    => 'text',
				'title'   => esc_html( 'Facebook' ),
				'default' => '#',
			],
			[
				'id'      => 'social_twitter',
				'type'    => 'text',
				'title'   => esc_html( 'Twitter' ),
				'default' => '#',
			],
			[
				'id'      => 'social_gplus',
				'type'    => 'text',
				'title'   => esc_html( 'Google Plus' ),
				'default' => '',
			],
			[
				'id'      => 'social_linkedin',
				'type'    => 'text',
				'title'   => esc_html( 'Linkedin' ),
				'default' => '#',
			],
			[
				'id'      => 'social_youtube',
				'type'    => 'text',
				'title'   => esc_html( 'Youtube' ),
				'default' => '',
			],
			[
				'id'      => 'social_pinterest',
				'type'    => 'text',
				'title'   => esc_html( 'Pinterest' ),
				'default' => '#',
			],
			[
				'id'      => 'social_instagram',
				'type'    => 'text',
				'title'   => esc_html( 'Instagram' ),
				'default' => '#',
			],
			[
				'id'      => 'social_skype',
				'type'    => 'text',
				'title'   => esc_html( 'Skype' ),
				'default' => '',
			],
			[
				'id'      => 'social_rss',
				'type'    => 'text',
				'title'   => esc_html( 'RSS' ),
				'default' => '',
			],
			[
				'id'      => 'social_tiktok',
				'type'    => 'text',
				'title'   => esc_html( 'Tiktok' ),
				'default' => '',
			],
		],
	]
);

Redux::setSection( $opt_name,
	[
		'title'   => esc_html( 'Header' ),
		'id'      => 'header_section',
		'heading' => '',
		'icon'    => 'el el-caret-up',
		'fields'  => [
			[
				'id'      => 'site_logo_type',
				'type'    => 'switch',
				'title'   => esc_html( 'Choose Logo Type' ),
				'on'      => esc_html( 'Image Logo' ),
				'off'     => esc_html( 'Text Logo' ),
				'default' => true,
			],

			//Image Logo
			[
				'id'       => 'logo',
				'type'     => 'media',
				'title'    => esc_html( 'Main Logo' ),
				'default'  => [
					'url' => RDTHEME_IMG_URL . 'logo-dark.svg',
				],
				'required' => [ 'site_logo_type', '=', true ],
			],

			[
				'id'       => 'logo_light',
				'type'     => 'media',
				'title'    => esc_html( 'Light Logo' ),
				'default'  => [
					'url' => RDTHEME_IMG_URL . 'logo-light.svg',
				],
				'subtitle' => esc_html( 'Used when Transparent Header is enabled' ),
				'required' => [ 'site_logo_type', '=', true ],
			],

			//Text Logo
			[
				'id'       => 'enable_title_tags',
				'type'     => 'switch',
				'title'    => esc_html( 'Enable Title Tag' ),
				'on'       => esc_html( 'Enable' ),
				'off'      => esc_html( 'Disable' ),
				'default'  => true,
				'required' => [ 'site_logo_type', '!=', true ],
			],

			[
				'id'       => 'logo_text_font_size',
				'type'     => 'text',
				'validate' => 'numeric',
				'title'    => esc_html( 'Logo Font Size' ),
				'required' => [ 'site_logo_type', '!=', true ],
			],

			[
				'id'       => 'logo_text_tag_font_size',
				'type'     => 'text',
				'validate' => 'numeric',
				'title'    => esc_html( 'Title Tag Font Size' ),
				'required' => [ 'enable_title_tags', '=', true ],
			],

			[
				'id'          => 'text_logo_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Text Logo Color' ),
				'required' => [ 'site_logo_type', '!=', true ],
			],

			[
				'id'          => 'text_logo_tag_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Title Tag Color' ),
				'required'    => [ 'enable_title_tags', '=', true ],
			],

			[
				'id'       => 'logo_width',
				'type'     => 'select',
				'title'    => esc_html( 'Logo Area Width' ),
				'subtitle' => esc_html( "Width is defined by the number of bootstrap columns. Please note, navigation menu width will be decreased with the increase of logo width<br/>Note: Not applicable for Header 5",
					),
				'options'  => [
					'1' => esc_html( '1 Column' ),
					'2' => esc_html( '2 Column' ),
					'3' => esc_html( '3 Column' ),
					'4' => esc_html( '4 Column' ),
				],
				'default'  => '2',
			],

			[
				'id'       => 'logo_strict_width',
				'type'     => 'text',
				'validate' => 'numeric',
				'title'    => esc_html( 'Logo Width' ),
				'subtitle' => esc_html( 'You may use logo width. It will be applied on logo strictly' ),
			],

			[
				'id'       => 'logo_strict_height',
				'type'     => 'text',
				'validate' => 'numeric',
				'title'    => esc_html( 'Logo Height' ),
				'subtitle' => esc_html( 'You may use logo Height. It will be applied on logo strictly' ),
			],

			[
				'id'       => 'sticky_menu',
				'type'     => 'switch',
				'title'    => esc_html( 'Sticky Header' ),
				'on'       => esc_html( 'Enabled' ),
				'off'      => esc_html( 'Disabled' ),
				'default'  => true,
				'subtitle' => esc_html( 'Show header when scroll down' ),
			],
			[
				'id'       => 'tr_header',
				'type'     => 'switch',
				'title'    => esc_html( 'Transparent Header' ),
				'on'       => esc_html( 'Enabled' ),
				'off'      => esc_html( 'Disabled' ),
				'default'  => false,
				'subtitle' => esc_html( 'You have to enable Banner or Slider in page to make it work properly. You can override this settings in individual pages' ),
			],
			[
				'id'       => 'top_bar',
				'type'     => 'switch',
				'title'    => esc_html( 'Top Bar' ),
				'on'       => esc_html( 'Enabled' ),
				'off'      => esc_html( 'Disabled' ),
				'default'  => true,
				'subtitle' => esc_html( 'You can override this settings in individual pages' ),
			],
			[
				'id'       => 'top_bar_style',
				'type'     => 'image_select',
				'title'    => esc_html( 'Top Bar Layout' ),
				'default'  => '4',
				'options'  => [
					'4' => [
						'title' => '<b>' . esc_html( 'Layout 1' ) . '</b>',
						'img'   => RDTHEME_IMG_URL . 'top4.jpg',
					],
					'1' => [
						'title' => '<b>' . esc_html( 'Layout 2' ) . '</b>',
						'img'   => RDTHEME_IMG_URL . 'top1.jpg',
					],
					'2' => [
						'title' => '<b>' . esc_html( 'Layout 3' ) . '</b>',
						'img'   => RDTHEME_IMG_URL . 'top2.jpg',
					],
					'3' => [
						'title' => '<b>' . esc_html( 'Layout 4' ) . '</b>',
						'img'   => RDTHEME_IMG_URL . 'top3.jpg',
					],
					'5' => [
						'title' => '<b>' . esc_html( 'Layout 5' ),
						'img'   => RDTHEME_IMG_URL . 'top5.jpg',
					],
					'6' => [
						'title' => '<b>' . esc_html( 'Layout 6' ),
						'img'   => RDTHEME_IMG_URL . 'top6.jpg',
					],
					'7' => [
						'title' => '<b>' . esc_html( 'Layout 7' ) . '</b> - You need to set it up from widget area',
						'img'   => RDTHEME_IMG_URL . 'top7.jpg',
					],
				],
				'subtitle' => esc_html( 'You can override this settings in individual pages' ),
				'required' => [ 'top_bar', '=', true ],
			],
			[
				'id'          => 'top_bar_bgcolor',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Top Bar Background Color' ),
				'default'     => '#002147',
				'required'    => [ 'top_bar', '=', true ],
			],
			[
				'id'          => 'top_bar_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Top Bar Text Color' ),
				'default'     => '#c2d1e2',
				'required'    => [ 'top_bar', '=', true ],
			],
			[
				'id'          => 'top_bar_icon_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Top Bar Icon Color' ),
				'default'     => '#fdc800',
				'required'    => [ 'top_bar', '=', true ],
			],
			[
				'id'          => 'top_bar_color_tr',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Transparent Top Bar Text Color' ),
				'subtitle'    => esc_html( 'Applied when Transparent Header is enabled' ),
				'default'     => '#d0d6dd',
				'required'    => [ 'top_bar', '=', true ],
			],
			[
				'id'       => 'header_style',
				'type'     => 'image_select',
				'title'    => esc_html( 'Header Layout' ),
				'default'  => '1',
				'options'  => [
					'1' => [
						'title' => '<b>' . esc_html( 'Layout 1' ) . '</b>',
						'img'   => RDTHEME_IMG_URL . 'header-1.jpg',
					],
					'6' => [
						'title' => '<b>' . esc_html( 'Layout 2' ) . '</b>',
						'img'   => RDTHEME_IMG_URL . 'header-6.jpg',
					],
					'2' => [
						'title' => '<b>' . esc_html( 'Layout 3' ) . '</b>',
						'img'   => RDTHEME_IMG_URL . 'header-2.jpg',
					],
					'3' => [
						'title' => '<b>' . esc_html( 'Layout 4' ) . '</b>',
						'img'   => RDTHEME_IMG_URL . 'header-3.jpg',
					],
					'4' => [
						'title' => '<b>' . esc_html( 'Layout 5' ) . '</b>',
						'img'   => RDTHEME_IMG_URL . 'header-4.jpg',
					],
					'5' => [
						'title' => '<b>' . esc_html( 'Layout 6' ) . '</b>',
						'img'   => RDTHEME_IMG_URL . 'header-5.jpg',
					],
					'7' => [
						'title' => '<b>' . esc_html( 'Layout 7' ) . '</b>',
						'img'   => RDTHEME_IMG_URL . 'header-7.jpg',
					],
					'8' => [
						'title' => '<b>' . esc_html( 'Layout 8' ) . '</b>',
						'img'   => RDTHEME_IMG_URL . 'header-8.jpg',
					],
					'9' => [
						'title' => '<b>' . esc_html( 'Layout 9' ) . '</b>',
						'img'   => RDTHEME_IMG_URL . 'header-9.jpg',
					],
					'10' => [
						'title' => '<b>' . esc_html( 'Layout 10' ) . '</b>',
						'img'   => RDTHEME_IMG_URL . 'header-10.jpg',
					],
				],
				'subtitle' => esc_html( 'You can override this settings in individual pages' ),
			],
			[
				'id'       => 'header_btn_txt',
				'type'     => 'text',
				'title'    => esc_html( 'Header Button Text' ),
				'subtitle' => esc_html( 'Applicable depending on Topbar/Header Layout' ),
				'default'  => esc_html( 'Apply Now' ),
			],
			[
				'id'       => 'header_btn_url',
				'type'     => 'text',
				'title'    => esc_html( 'Header Button URL' ),
				'subtitle' => esc_html( 'Applicable depending on Topbar/Header Layout' ),
				'default'  => '#',
			],
			[
				'id'      => 'search_icon',
				'type'    => 'switch',
				'title'   => esc_html( 'Search Icon' ),
				'on'      => esc_html( 'Enabled' ),
				'off'     => esc_html( 'Disabled' ),
				'default' => true,
			],
			[
				'id'      => 'cart_icon',
				'type'    => 'switch',
				'title'   => esc_html( 'Cart Icon' ),
				'on'      => esc_html( 'Enabled' ),
				'off'     => esc_html( 'Disabled' ),
				'default' => true,
			],
			[
				'id'      => 'vertical_menu_icon',
				'type'    => 'switch',
				'title'   => esc_html( 'Vertical Menu Icon' ),
				'on'      => esc_html( 'Enabled' ),
				'off'     => esc_html( 'Disabled' ),
				'default' => true,
			],
			[
				'id'       => 'menu_contact_us',
				'type'     => 'switch',
				'title'    => esc_html( 'Contact Us' ),
				'on'       => esc_html( 'Enabled' ),
				'off'      => esc_html( 'Disabled' ),
				'default'  => true,
				'required' => [ 'header_style', 'equals', '8' ],
			],
		],
	]
);

Redux::setSection( $opt_name,
	[
		'title'   => esc_html( 'Main Menu' ),
		'id'      => 'menu_section',
		'heading' => '',
		'icon'    => 'el el-book',
		'fields'  => [
			[
				'id'     => 'section-mainmenu',
				'type'   => 'section',
				'title'  => esc_html( 'Main Menu Items' ),
				'indent' => true,
			],
			[
				'id'             => 'menu_typo',
				'type'           => 'typography',
				'title'          => esc_html( 'Menu Font' ),
				'google'         => true,
				'subsets'        => false,
				'text-align'     => false,
				'color'          => false,
				'text-transform' => true,
				'default'        => [
					'font-family'    => 'Roboto',
					'google'         => true,
					'font-size'      => '15px',
					'font-weight'    => '500',
					'line-height'    => '24px',
					'text-transform' => 'uppercase',
				],
			],
			[
				'id'          => 'menu_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Menu Color' ),
				'default'     => '#002147',
				'required'    => [ 'header_style', '!=', '6' ],
			],
			[
				'id'          => 'menu_color_alt',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Menu Color' ),
				'default'     => '#ffffff',
				'required'    => [ 'header_style', '=', '6' ],
			],
			[
				'id'          => 'menu_color_tr',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Transparent Menu Color' ),
				'subtitle'    => esc_html( 'Applied when Transparent Header is enabled' ),
				'default'     => '#fff',
			],
			[
				'id'          => 'menu_hover_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Menu Hover Color' ),
				'default'     => '#fdc800',
			],
			[
				'id'     => 'section-submenu',
				'type'   => 'section',
				'title'  => esc_html( 'Sub Menu Items' ),
				'indent' => true,
			],
			[
				'id'             => 'submenu_typo',
				'type'           => 'typography',
				'title'          => esc_html( 'Submenu Font' ),
				'google'         => true,
				'subsets'        => false,
				'text-align'     => false,
				'color'          => false,
				'text-transform' => true,
				'default'        => [
					'font-family'    => 'Roboto',
					'google'         => true,
					'font-size'      => '14px',
					'font-weight'    => '400',
					'line-height'    => '21px',
					'text-transform' => 'uppercase',
				],
			],
			[
				'id'          => 'submenu_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Submenu Color' ),
				'default'     => '#d9dee4',
			],
			[
				'id'          => 'submenu_bgcolor',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Submenu Background Color' ),
				'default'     => '#002147',
			],
			[
				'id'          => 'submenu_hover_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Submenu Hover Color' ),
				'default'     => '#FDC800',
			],
			[
				'id'          => 'submenu_hover_bgcolor',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Submenu Hover Background Color' ),
				'default'     => '#1A3B61',
			],
			[
				'id'     => 'section-resmenu',
				'type'   => 'section',
				'title'  => esc_html( 'Mobile Menu' ),
				'indent' => true,
			],
			[
				'id'       => 'resmenu_width',
				'type'     => 'slider',
				'title'    => esc_html( 'Screen width in which mobile menu activated' ),
				'subtitle' => esc_html( 'Recommended value is: 992' ),
				'default'  => 992,
				'min'      => 0,
				'step'     => 1,
				'max'      => 2000,
			],
			[
				'id'             => 'resmenu_typo',
				'type'           => 'typography',
				'title'          => esc_html( 'Mobile Menu Font' ),
				'google'         => true,
				'subsets'        => false,
				'text-align'     => false,
				'color'          => false,
				'text-transform' => true,
				'default'        => [
					'font-family'    => 'Roboto',
					'google'         => true,
					'font-size'      => '14px',
					'font-weight'    => '400',
					'line-height'    => '21px',
					'text-transform' => 'uppercase',
				],
			],
		],
	]
);

Redux::setSection( $opt_name,
	[
		'title'   => esc_html( 'Banner' ),
		'id'      => 'banner_section',
		'heading' => '',
		'icon'    => 'el el-flag',
		'fields'  => [
			[
				'id'          => 'banner_heading_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Banner Heading Color' ),
				'default'     => '#ffffff',
			],
			[
				'id'          => 'breadcrumb_link_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Breadcrumb Link Color' ),
				'default'     => '#fdc800',
			],
			[
				'id'          => 'breadcrumb_link_hover_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Breadcrumb Link Hover Color' ),
				'default'     => '#ffffff',
			],
			[
				'id'          => 'breadcrumb_active_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Active Breadcrumb Color' ),
				'default'     => '#ffffff',
			],
			[
				'id'          => 'breadcrumb_seperator_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Breadcrumb Seperator Color' ),
				'default'     => '#ffffff',
			],
		],
	]
);

Redux::setSection( $opt_name,
	[
		'title'   => esc_html( 'Footer' ),
		'id'      => 'footer_section',
		'heading' => '',
		'icon'    => 'el el-caret-down',
		'fields'  => [
			[
				'id'       => 'footer_style',
				'type'     => 'image_select',
				'title'    => esc_html( 'Footer Layout' ),
				'default'  => '1',
				'options'  => [
					'1' => [
						'title' => '<b>' . esc_html( 'Layout 1' ) . '</b>',
						'img'   => RDTHEME_IMG_URL . 'footer-1.jpg',
					],
					'2' => [
						'title' => '<b>' . esc_html( 'Layout 2' ) . '</b>',
						'img'   => RDTHEME_IMG_URL . 'footer-2.jpg',
					],
					'3' => [
						'title' => '<b>' . esc_html( 'Layout 3' ) . '</b>',
						'img'   => RDTHEME_IMG_URL . 'footer-3.jpg',
					],
				],
				'subtitle' => esc_html( 'You can override this settings in individual pages' ),
			],

			[
				'id'     => 'section-footer-area',
				'type'   => 'section',
				'title'  => esc_html( 'Footer Area' ),
				'indent' => true,
			],
			[
				'id'      => 'footer_area',
				'type'    => 'switch',
				'title'   => esc_html( 'Display Footer Area' ),
				'on'      => esc_html( 'Enabled' ),
				'off'     => esc_html( 'Disabled' ),
				'default' => true,
			],
			[
				'id'       => 'footer_column',
				'type'     => 'select',
				'title'    => esc_html( 'Number of Columns' ),
				'options'  => [
					'1' => esc_html( '1 Column' ),
					'2' => esc_html( '2 Columns' ),
					'3' => esc_html( '3 Columns' ),
					'4' => esc_html( '4 Columns' ),
				],
				'default'  => '4',
				'required' => [ 'footer_area', 'equals', true ],
			],
			[
				'id'          => 'footer_bgcolor',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Footer Background Color' ),
				'default'     => '#002147',
				'required'    => [ 'footer_area', 'equals', true ],
			],
			[
				'id'          => 'footer_title_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Footer Title Text Color' ),
				'default'     => '#ffffff',
				'required'    => [ 'footer_area', 'equals', true ],
			],
			[
				'id'          => 'footer_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Footer Body Text Color' ),
				'default'     => '#bdc4cd',
				'required'    => [ 'footer_area', 'equals', true ],
			],
			[
				'id'          => 'footer_link_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Footer Body Link Color' ),
				'default'     => '#bdc4cd',
				'required'    => [ 'footer_area', 'equals', true ],
			],
			[
				'id'          => 'footer_link_hover_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Footer Body Link Hover Color' ),
				'default'     => '#fdc800',
				'required'    => [ 'footer_area', 'equals', true ],
			],
			[
				'id'     => 'section-copyright-area',
				'type'   => 'section',
				'title'  => esc_html( 'Copyright Area' ),
				'indent' => true,
			],
			[
				'id'      => 'copyright_area',
				'type'    => 'switch',
				'title'   => esc_html( 'Display Copyright Area' ),
				'on'      => esc_html( 'Enabled' ),
				'off'     => esc_html( 'Disabled' ),
				'default' => true,
			],
			[
				'id'       => 'payment_icons',
				'type'     => 'switch',
				'title'    => esc_html( 'Display Payment Icons' ),
				'on'       => esc_html( 'Enabled' ),
				'off'      => esc_html( 'Disabled' ),
				'default'  => false,
				'required' => [ 'copyright_area', 'equals', true ],
			],
			[
				'id'       => 'payment_img',
				'type'     => 'gallery',
				'title'    => esc_html( 'Payment Icons Gallery' ),
				'required' => [ 'payment_icons', 'equals', true ],
			],
			[
				'id'          => 'copyright_bgcolor',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Copyright Background Color' ),
				'default'     => '#001a39',
				'required'    => [ 'copyright_area', 'equals', true ],
			],
			[
				'id'          => 'copyright_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html( 'Copyright Text Color' ),
				'default'     => '#909da4',
				'required'    => [ 'copyright_area', 'equals', true ],
			],
			[
				'id'       => 'copyright_text',
				'type'     => 'textarea',
				'title'    => esc_html( 'Copyright Text' ),
				'default'  => '&copy; Copyright Eikra 2021. by  <a target="_blank" href="' . RDTHEME_AUTHOR_URI . '">RadiusTheme</a>',
				'required' => [ 'copyright_area', 'equals', true ],
			],
		],
	]
);

Redux::setSection( $opt_name,
	[
		'title'  => esc_html( 'Typography' ),
		'id'     => 'typo_section',
		'icon'   => 'el el-text-width',
		'fields' => [
			[
				'id'          => 'typo_body',
				'type'        => 'typography',
				'title'       => esc_html( 'Body' ),
				'google'      => true,
				'subsets'     => false,
				'text-align'  => false,
				'font-weight' => false,
				'color'       => false,
				'default'     => [
					'font-family' => 'Roboto',
					'google'      => true,
					'font-size'   => '15px',
					'font-weight' => '400',
					'line-height' => '26px',
				],
			],
			[
				'id'          => 'typo_h1',
				'type'        => 'typography',
				'title'       => esc_html( 'Header h1' ),
				'google'      => true,
				'subsets'     => false,
				'text-align'  => false,
				'font-weight' => false,
				'color'       => false,
				'default'     => [
					'font-family' => 'Roboto',
					'google'      => true,
					'font-size'   => '40px',
					'font-weight' => '500',
					'line-height' => '44px',
				],
			],
			[
				'id'          => 'typo_h2',
				'type'        => 'typography',
				'title'       => esc_html( 'Header h2' ),
				'google'      => true,
				'subsets'     => false,
				'text-align'  => false,
				'font-weight' => false,
				'color'       => false,
				'default'     => [
					'font-family' => 'Roboto',
					'google'      => true,
					'font-size'   => '28px',
					'font-weight' => '500',
					'line-height' => '31px',
				],
			],
			[
				'id'          => 'typo_h3',
				'type'        => 'typography',
				'title'       => esc_html( 'Header h3' ),
				'google'      => true,
				'subsets'     => false,
				'text-align'  => false,
				'font-weight' => false,
				'color'       => false,
				'default'     => [
					'font-family' => 'Roboto',
					'google'      => true,
					'font-size'   => '20px',
					'font-weight' => '500',
					'line-height' => '26px',
				],
			],
			[
				'id'          => 'typo_h4',
				'type'        => 'typography',
				'title'       => esc_html( 'Header h4' ),
				'google'      => true,
				'subsets'     => false,
				'text-align'  => false,
				'font-weight' => false,
				'color'       => false,
				'default'     => [
					'font-family' => 'Roboto',
					'google'      => true,
					'font-size'   => '16px',
					'font-weight' => '500',
					'line-height' => '18px',
				],
			],
			[
				'id'          => 'typo_h5',
				'type'        => 'typography',
				'title'       => esc_html( 'Header h5' ),
				'google'      => true,
				'subsets'     => false,
				'text-align'  => false,
				'font-weight' => false,
				'color'       => false,
				'default'     => [
					'font-family' => 'Roboto',
					'google'      => true,
					'font-size'   => '14px',
					'font-weight' => '500',
					'line-height' => '16px',
				],
			],
			[
				'id'          => 'typo_h6',
				'type'        => 'typography',
				'title'       => esc_html( 'Header h6' ),
				'google'      => true,
				'subsets'     => false,
				'text-align'  => false,
				'font-weight' => false,
				'color'       => false,
				'default'     => [
					'font-family' => 'Roboto',
					'google'      => true,
					'font-size'   => '12px',
					'font-weight' => '500',
					'line-height' => '14px',
				],
			],
		],
	]
);

// Generate Common post type fields
function rdtheme_redux_post_type_fields( $prefix ) {

	return [

		[
			'id'      => $prefix . '_layout',
			'type'    => 'image_select',
			'title'   => esc_html( 'Layout' ),
			'options' => [

				'left-sidebar'  => [
					'alt'   => esc_html( 'Left Sidebar' ),
					'title' => esc_html( 'Left Sidebar' ),
					'img'   => RDTHEME_IMG_URL . 'left-sidebar.png',
				],
				'full-width'    => [
					'alt'   => esc_html( 'Full Width' ),
					'title' => esc_html( 'Fullwidth' ),
					'img'   => RDTHEME_IMG_URL . 'fullwidth.png',
				],
				'right-sidebar' => [
					'alt'   => esc_html( 'Right Sidebar' ),
					'title' => esc_html( 'Right Sidebar' ),
					'img'   => RDTHEME_IMG_URL . 'right-sidebar.png',
				],
			],
			'default' => 'right-sidebar',
		],

		[
			'id'       => $prefix . '_sidebar',
			'type'     => 'select',
			'title'    => esc_html( 'Sidebar' ),
			'options'  => RDTheme_Helper::custom_sidebar_fields(),
			'default'  => 'sidebar',
			'required' => [ $prefix . '_layout', '!=', 'full-width' ],
		],
		[
			'id'       => $prefix . '_padding_top',
			'type'     => 'text',
			'title'    => esc_html( 'Content Padding Top' ),
			'validate' => 'numeric',
			'default'  => '100',
		],
		[
			'id'       => $prefix . '_padding_bottom',
			'type'     => 'text',
			'title'    => esc_html( 'Content Padding Bottom' ),
			'validate' => 'numeric',
			'default'  => '100',
		],
		[
			'id'      => $prefix . '_banner',
			'type'    => 'switch',
			'title'   => esc_html( 'Banner' ),
			'on'      => esc_html( 'Enabled' ),
			'off'     => esc_html( 'Disabled' ),
			'default' => true,
		],
		[
			'id'       => $prefix . '_breadcrumb',
			'type'     => 'switch',
			'title'    => esc_html( 'Breadcrumb' ),
			'on'       => esc_html( 'Enabled' ),
			'off'      => esc_html( 'Disabled' ),
			'default'  => true,
			'required' => [ $prefix . '_banner', 'equals', true ],
		],
		[
			'id'       => $prefix . '_bgtype',
			'type'     => 'button_set',
			'title'    => esc_html( 'Banner Background Type' ),
			'options'  => [
				'bgimg'   => esc_html( 'Background Image' ),
				'bgcolor' => esc_html( 'Background Color' ),
			],
			'default'  => 'bgimg',
			'required' => [ $prefix . '_banner', 'equals', true ],
		],
		[
			'id'       => $prefix . '_bgimg',
			'type'     => 'media',
			'title'    => esc_html( 'Banner Background Image' ),
			'default'  => [
				'url' => RDTHEME_IMG_URL . 'banner.jpg',
			],
			'required' => [ $prefix . '_bgtype', 'equals', 'bgimg' ],
		],
		[
			'id'          => $prefix . '_bgcolor',
			'type'        => 'color',
			'title'       => esc_html( 'Banner Background Color' ),
			'validate'    => 'color',
			'transparent' => false,
			'default'     => '#606060',
			'required'    => [ $prefix . '_bgtype', 'equals', 'bgcolor' ],
		],
	];
}

Redux::setSection( $opt_name,
	[
		'title' => esc_html( 'Layout Defaults' ),
		'id'    => 'layout_defaults',
		'icon'  => 'el el-th',
	]
);

// Page
$rdtheme_page_fields               = rdtheme_redux_post_type_fields( 'page' );
$rdtheme_page_fields[0]['default'] = 'full-width';
Redux::setSection( $opt_name,
	[
		'title'      => esc_html( 'Page' ),
		'id'         => 'pages_section',
		'subsection' => true,
		'fields'     => $rdtheme_page_fields,
	]
);

//Post Archive
$rdtheme_post_archive_fields = rdtheme_redux_post_type_fields( 'blog' );
Redux::setSection( $opt_name,
	[
		'title'      => esc_html( 'Blog / Archive' ),
		'id'         => 'blog_section',
		'subsection' => true,
		'fields'     => $rdtheme_post_archive_fields,
	]
);

// Single Post
$rdtheme_single_post_fields = rdtheme_redux_post_type_fields( 'single_post' );
Redux::setSection( $opt_name,
	[
		'title'      => esc_html( 'Post Single' ),
		'id'         => 'single_post_section',
		'subsection' => true,
		'fields'     => $rdtheme_single_post_fields,
	]
);

// Course Archive
$rdtheme_course_field1 = [
	'id'      => 'course_style',
	'type'    => 'button_set',
	'title'   => esc_html( 'Style' ),
	'class'   => RDTheme_Helper::is_LMS() ? '' : 'hide',
	'options' => [
		'1' => esc_html( 'Style 1' ),
		'2' => esc_html( 'Style 2' ),
		'3' => esc_html( 'Style 3' ),
		'4' => esc_html( 'Style 4' ),
	],
	'default' => '1',
];
$rdtheme_course_fields = rdtheme_redux_post_type_fields( 'course_archive' );
// if ( RDTheme_Helper::is_LMS() ) {
// 	unset( $rdtheme_course_fields[1] );
// }
array_unshift( $rdtheme_course_fields, $rdtheme_course_field1 );

Redux::setSection( $opt_name,
	[
		'title'      => esc_html( 'Course Archive' ),
		'id'         => 'course_archive_section',
		'subsection' => true,
		'fields'     => $rdtheme_course_fields,
	]
);

// Course Single
$rdtheme_single_course_fields = rdtheme_redux_post_type_fields( 'single_course' );
// if ( RDTheme_Helper::is_LMS() ) {
// 	unset( $rdtheme_single_course_fields[1] );
// }
Redux::setSection( $opt_name,
	[
		'title'      => esc_html( 'Single Course' ),
		'id'         => 'single_course_section',
		'subsection' => true,
		'fields'     => $rdtheme_single_course_fields,
	]
);

// Instructor Single
$rdtheme_single_instructor_fields = rdtheme_redux_post_type_fields( 'instructor' );
unset( $rdtheme_single_instructor_fields[0] );
unset( $rdtheme_single_instructor_fields[1] );
Redux::setSection( $opt_name,
	[
		'title'      => esc_html( 'Single Instructor' ),
		'id'         => 'single_instructor_section',
		'subsection' => true,
		'fields'     => $rdtheme_single_instructor_fields,
	]
);

// Research Single
$rdtheme_research_fields = rdtheme_redux_post_type_fields( 'research' );
Redux::setSection( $opt_name,
	[
		'title'      => esc_html( 'Single Research' ),
		'id'         => 'single_research_section',
		'subsection' => true,
		'fields'     => $rdtheme_research_fields,
	]
);

// Event Single
$event_fields = rdtheme_redux_post_type_fields( 'event' );
Redux::setSection( $opt_name,
	[
		'title'      => esc_html( 'Single Event' ),
		'id'         => 'single_event_section',
		'subsection' => true,
		'fields'     => $event_fields,
	]
);

// Search
$rdtheme_search_fields = rdtheme_redux_post_type_fields( 'search' );
Redux::setSection( $opt_name,
	[
		'title'      => esc_html( 'Search Layout' ),
		'id'         => 'search_section',
		'subsection' => true,
		'fields'     => $rdtheme_search_fields,
	]
);

// Error 404 Layout
$rdtheme_error_fields = rdtheme_redux_post_type_fields( 'error' );
unset( $rdtheme_error_fields[0] );
Redux::setSection( $opt_name,
	[
		'title'      => esc_html( 'Error 404 Layout' ),
		'id'         => 'error_section',
		'subsection' => true,
		'fields'     => $rdtheme_error_fields,
	]
);

if ( class_exists( 'WooCommerce' ) ) {
	// Woocommerce Shop Archive
	$rdtheme_shop_archive_fields = rdtheme_redux_post_type_fields( 'shop' );
	Redux::setSection( $opt_name,
		[
			'title'      => esc_html( 'Shop Archive' ),
			'id'         => 'shop_section',
			'subsection' => true,
			'fields'     => $rdtheme_shop_archive_fields,
		]
	);

	// Woocommerce Product
	$rdtheme_product_fields = rdtheme_redux_post_type_fields( 'product' );
	Redux::setSection( $opt_name,
		[
			'title'      => esc_html( 'Product Single' ),
			'id'         => 'product_section',
			'subsection' => true,
			'fields'     => $rdtheme_product_fields,
		]
	);
}

// Blog Settings
Redux::setSection( $opt_name,
	[
		'title'   => esc_html( 'Blog Settings' ),
		'id'      => 'blog_settings_section',
		'icon'    => 'el el-tags',
		'heading' => '',
		'fields'  => [
			[
				'id'      => 'blog_style',
				'type'    => 'image_select',
				'title'   => esc_html( 'Blog/Archive Layout' ),
				'default' => 'style1',
				'options' => [
					'style1' => [
						'title' => '<b>' . esc_html( 'Layout 1' ) . '</b>',
						'img'   => RDTHEME_IMG_URL . 'blog1.png',
					],
					'style2' => [
						'title' => '<b>' . esc_html( 'Layout 2' ) . '</b>',
						'img'   => RDTHEME_IMG_URL . 'blog2.png',
					],
				],
			],
			[
				'id'      => 'blog_date',
				'type'    => 'switch',
				'title'   => esc_html( 'Show Date' ),
				'on'      => esc_html( 'On' ),
				'off'     => esc_html( 'Off' ),
				'default' => true,
			],
			[
				'id'      => 'blog_author_name',
				'type'    => 'switch',
				'title'   => esc_html( 'Show Author Name' ),
				'on'      => esc_html( 'On' ),
				'off'     => esc_html( 'Off' ),
				'default' => true,
			],
			[
				'id'      => 'blog_cats',
				'type'    => 'switch',
				'title'   => esc_html( 'Show Categories' ),
				'on'      => esc_html( 'On' ),
				'off'     => esc_html( 'Off' ),
				'default' => true,
			],
			[
				'id'      => 'blog_comment_num',
				'type'    => 'switch',
				'title'   => esc_html( 'Show Comment Number' ),
				'on'      => esc_html( 'On' ),
				'off'     => esc_html( 'Off' ),
				'default' => true,
			],
		],
	]
);

// Post Settings
Redux::setSection( $opt_name,
	[
		'title'   => esc_html( 'Post Settings' ),
		'id'      => 'post_settings_section',
		'icon'    => 'el el-file-edit',
		'heading' => '',
		'fields'  => [
			[
				'id'      => 'post_date',
				'type'    => 'switch',
				'title'   => esc_html( 'Show Post Date' ),
				'on'      => esc_html( 'On' ),
				'off'     => esc_html( 'Off' ),
				'default' => true,
			],
			[
				'id'      => 'post_author_name',
				'type'    => 'switch',
				'title'   => esc_html( 'Show Author Name' ),
				'on'      => esc_html( 'On' ),
				'off'     => esc_html( 'Off' ),
				'default' => true,
			],
			[
				'id'      => 'post_cats',
				'type'    => 'switch',
				'title'   => esc_html( 'Show Categories' ),
				'on'      => esc_html( 'On' ),
				'off'     => esc_html( 'Off' ),
				'default' => true,
			],
			[
				'id'      => 'post_comment_num',
				'type'    => 'switch',
				'title'   => esc_html( 'Show Comment Number' ),
				'on'      => esc_html( 'On' ),
				'off'     => esc_html( 'Off' ),
				'default' => true,
			],
			[
				'id'      => 'post_tags',
				'type'    => 'switch',
				'title'   => esc_html( 'Show Tags' ),
				'on'      => esc_html( 'On' ),
				'off'     => esc_html( 'Off' ),
				'default' => true,
			],
		],
	]
);

// Course Settings
Redux::setSection( $opt_name,
	[
		'title'   => esc_html( 'Course Settings' ),
		'id'      => 'course_settings_section',
		'icon'    => 'el el-file-edit',
		'heading' => '',
		'fields'  => [
			[
				'id'       => 'course_price_hide',
				'type'     => 'switch',
				'class'    => RDTheme_Helper::is_LMS() ? '' : 'hide',
				'title'    => esc_html( 'Sitewide Hide Price' ),
				'on'       => esc_html( 'Enabled' ),
				'off'      => esc_html( 'Disabled' ),
				'default'  => false,
				'subtitle' => esc_html( 'If enabled then hide prices from everywhere' ),
			],
			[
				'id'      => 'course_meta',
				'type'    => 'checkbox',
				'class'   => RDTheme_Helper::is_LMS() ? '' : 'hide',
				'title'   => esc_html( 'Show Information' ),
				'options' => [
					'ins' => esc_html( 'Instructor' ),
					'lec' => esc_html( 'Lectures' ),
					'qz'  => esc_html( 'Quizzes' ),
					'stu' => esc_html( 'Students' ),
					'dur' => esc_html( 'Duration' ),
				],
				'default' => [
					'ins' => '1',
					'lec' => '1',
					'qz'  => '1',
					'stu' => '1',
					'dur' => '1',
				],
			],
			[
				'id'      => 'course_cats',
				'type'    => 'switch',
				'title'   => esc_html( 'Show Categories' ),
				'on'      => esc_html( 'On' ),
				'off'     => esc_html( 'Off' ),
				'default' => true,
			],
			[
				'id'      => 'course_tags',
				'type'    => 'switch',
				'title'   => esc_html( 'Show Tags' ),
				'on'      => esc_html( 'On' ),
				'off'     => esc_html( 'Off' ),
				'default' => true,
			],
			[
				'id'      => 'course_curriculum',
				'type'    => 'switch',
				'class'   => RDTheme_Helper::is_LMS() ? '' : 'hide',
				'title'   => esc_html( 'Show Curriculum Tab' ),
				'on'      => esc_html( 'On' ),
				'off'     => esc_html( 'Off' ),
				'default' => true,
			],
			[
				'id'      => 'course_instructor',
				'type'    => 'switch',
				'class'   => RDTheme_Helper::is_LMS() ? '' : 'hide',
				'title'   => esc_html( 'Show Instructor Tab' ),
				'on'      => esc_html( 'On' ),
				'off'     => esc_html( 'Off' ),
				'default' => true,
			],
			[
				'id'      => 'course_review',
				'type'    => 'switch',
				'class'   => RDTheme_Helper::is_LMS() ? '' : 'hide',
				'title'   => esc_html( 'Show Review Tab' ),
				'on'      => esc_html( 'On' ),
				'off'     => esc_html( 'Off' ),
				'default' => true,
			],
			[
				'id'      => 'course_related',
				'type'    => 'switch',
				'title'   => esc_html( 'Show Related Courses' ),
				'on'      => esc_html( 'On' ),
				'off'     => esc_html( 'Off' ),
				'default' => true,
			],
			[
				'id'      => 'course_sidebar',
				'type'    => 'switch',
				'class'   => RDTheme_Helper::is_LMS() ? '' : 'hide',
				'title'   => esc_html( 'Show Sidebar' ),
				'on'      => esc_html( 'On' ),
				'off'     => esc_html( 'Off' ),
				'default' => true,
			],

			[
				'id'       => 'course_details_section',
				'type'     => 'section',
				'title'    => __( 'Course Details Sidebar Options' ),
				'subtitle' => __( 'These settings will apply for course details page.' ),
				'indent'   => false,
			],

			[
				'id'       => 'course_progress',
				'type'     => 'switch',
				'class'    => RDTheme_Helper::is_LMS() ? '' : 'hide',
				'title'    => esc_html( 'Show Progress Box' ),
				'on'       => esc_html( 'On' ),
				'off'      => esc_html( 'Off' ),
				'default'  => true,
				'subtitle' => esc_html( 'Available for enrolled users' ),
			],
			[
				'id'      => 'course_price',
				'type'    => 'switch',
				'class'   => RDTheme_Helper::is_LMS() ? '' : 'hide',
				'title'   => esc_html( 'Show Price Box' ),
				'on'      => esc_html( 'On' ),
				'off'     => esc_html( 'Off' ),
				'default' => true,
			],
			[
				'id'      => 'course_rating',
				'type'    => 'switch',
				'class'   => RDTheme_Helper::is_LMS() ? '' : 'hide',
				'title'   => esc_html( 'Show Rating Box' ),
				'on'      => esc_html( 'On' ),
				'off'     => esc_html( 'Off' ),
				'default' => true,
			],

			[
				'id'       => 'course_archive_section',
				'type'     => 'section',
				'title'    => __( 'Course Archive Options' ),
				'subtitle' => __( 'These settings will apply to all global courses.' ),
				'indent'   => false,
			],

			[
				'id'       => 'course_archive_cat_filter',
				'type'     => 'switch',
				'title'    => esc_html( 'Category Filter Search' ),
				'on'       => esc_html( 'Enable' ),
				'off'      => esc_html( 'Disable' ),
				'subtitle' => __( 'You may enable or disable category search filter options from archive search ' ),
				'default'  => true,
			],

			[
				'id'       => 'course_archive_instructor_visibility',
				'type'     => 'switch',
				'title'    => esc_html( 'Courses Instructor Visibility' ),
				'on'       => esc_html( 'On' ),
				'off'      => esc_html( 'Off' ),
				'subtitle' => __( 'You may show or hide course instructor for all global course.' ),
				'default'  => true,
			],

			[
				'id'       => 'course_archive_footer_visibility',
				'type'     => 'switch',
				'title'    => esc_html( 'Courses Footer Visibility' ),
				'on'       => esc_html( 'On' ),
				'off'      => esc_html( 'Off' ),
				'subtitle' => __( 'You may show or hide course footer section from all global course. Include: ( Enroll count, Review, Wishlist )' ),
				'default'  => true,
			],

			[
				'id'     => 'course_archive_footer_section',
				'type'   => 'section',
				'indent' => true,
			],

			[
				'id'       => 'course_archive_wishlist_visibility',
				'type'     => 'switch',
				'title'    => esc_html( 'Wishlist Visibility' ),
				'on'       => esc_html( 'On' ),
				'off'      => esc_html( 'Off' ),
				'subtitle' => esc_html( 'You may show or hide course footer wishlist' ),
				'default'  => true,
				'required' => [ 'course_archive_footer_visibility', '=', true ],
			],

			[
				'id'       => 'course_archive_enroll_visibility',
				'type'     => 'switch',
				'title'    => esc_html( 'Enroll Visibility' ),
				'on'       => esc_html( 'On' ),
				'off'      => esc_html( 'Off' ),
				'subtitle' => esc_html( 'You may show or hide course footer enroll' ),
				'default'  => true,
				'required' => [ 'course_archive_footer_visibility', '=', true ],
			],

			[
				'id'       => 'course_archive_review_visibility',
				'type'     => 'switch',
				'title'    => esc_html( 'Review Visibility' ),
				'on'       => esc_html( 'On' ),
				'off'      => esc_html( 'Off' ),
				'subtitle' => esc_html( 'You may show or hide course footer enroll' ),
				'default'  => true,
				'required' => [ 'course_archive_footer_visibility', '=', true ],
			],

			[
				'id'       => 'course_archive_price_visibility',
				'type'     => 'switch',
				'title'    => esc_html( 'Price Visibility' ),
				'on'       => esc_html( 'On' ),
				'off'      => esc_html( 'Off' ),
				'subtitle' => esc_html( 'You may show or hide course footer price' ),
				'default'  => true,
				'required' => [ 'course_archive_footer_visibility', '=', true ],
			],
			[
				'id'       => 'off_line_payment_logo',
				'type'     => 'media',
				'title'    => esc_html( 'Offline payment logo' ),
				'subtitle' => esc_html( 'If you need you can change the Offline payment logo from here.' ),
			],

		],
	]
);

// Error
$rdtheme_fields2 = [
	[
		'id'      => 'error_title',
		'type'    => 'text',
		'title'   => esc_html( 'Page Title' ),
		'default' => esc_html( 'Error 404' ),
	],
	[
		'id'          => 'error_bodybg',
		'type'        => 'color',
		'transparent' => false,
		'title'       => esc_html( 'Body Background Color' ),
		'default'     => '#FDC800',
	],
	[
		'id'      => 'error_bodybanner',
		'type'    => 'media',
		'title'   => esc_html( 'Body Banner' ),
		'default' => [
			'url' => RDTHEME_IMG_URL . '404.png',
		],
	],
	[
		'id'      => 'error_text1',
		'type'    => 'text',
		'title'   => esc_html( 'Body Text 1' ),
		'default' => esc_html( 'Page not Found' ),
	],
	[
		'id'      => 'error_text2',
		'type'    => 'text',
		'title'   => esc_html( 'Body Text 2' ),
		'default' => esc_html( 'The page you are looking is not available or has been removed. Try going to Home Page by using the button below.' ),
	],
	[
		'id'          => 'error_text1_color',
		'type'        => 'color',
		'transparent' => false,
		'title'       => esc_html( 'Body Text 1 Color' ),
		'default'     => '#000000',
	],
	[
		'id'          => 'error_text2_color',
		'type'        => 'color',
		'transparent' => false,
		'title'       => esc_html( 'Body Text 2 Color' ),
		'default'     => '#634e00',
	],
	[
		'id'      => 'error_buttontext',
		'type'    => 'text',
		'title'   => esc_html( 'Button Text' ),
		'default' => esc_html( 'Go to Home Page' ),
	],
];
Redux::setSection( $opt_name,
	[
		'title'   => esc_html( 'Error Page Settings' ),
		'id'      => 'error_srttings_section',
		'heading' => '',
		'icon'    => 'el el-error-alt',
		'fields'  => $rdtheme_fields2,
	]
);

if ( class_exists( 'WooCommerce' ) ) {
	// Woocommerce Settings
	Redux::setSection( $opt_name,
		[
			'title'   => esc_html( 'WooCommerce' ),
			'id'      => 'woo_Settings_section',
			'heading' => '',
			'icon'    => 'el el-shopping-cart',
			'fields'  => [
				[
					'id'     => 'wc_sec_general',
					'type'   => 'section',
					'title'  => esc_html( 'General' ),
					'indent' => true,
				],
				[
					'id'      => 'wc_num_product',
					'type'    => 'text',
					'title'   => esc_html( 'Number of Products Per Page' ),
					'default' => '9',
				],
				[
					'id'      => 'wc_wishlist_icon',
					'type'    => 'switch',
					'title'   => esc_html( 'Product Add to Wishlist Icon' ),
					'on'      => esc_html( 'Enabled' ),
					'off'     => esc_html( 'Disabled' ),
					'default' => true,
				],
				[
					'id'      => 'wc_quickview_icon',
					'type'    => 'switch',
					'title'   => esc_html( 'Product Quickview Icon' ),
					'on'      => esc_html( 'Enabled' ),
					'off'     => esc_html( 'Disabled' ),
					'default' => true,
				],
				[
					'id'     => 'wc_sec_product',
					'type'   => 'section',
					'title'  => esc_html( 'Product Single Page' ),
					'indent' => true,
				],
				[
					'id'      => 'wc_show_excerpt',
					'type'    => 'switch',
					'title'   => esc_html( "Show excerpt when short description doesn't exist" ),
					'on'      => esc_html( 'Enabled' ),
					'off'     => esc_html( 'Disabled' ),
					'default' => true,
				],
				[
					'id'      => 'wc_cats',
					'type'    => 'switch',
					'title'   => esc_html( 'Categories' ),
					'on'      => esc_html( 'Show' ),
					'off'     => esc_html( 'Hide' ),
					'default' => true,
				],
				[
					'id'      => 'wc_tags',
					'type'    => 'switch',
					'title'   => esc_html( 'Tags' ),
					'on'      => esc_html( 'Show' ),
					'off'     => esc_html( 'Hide' ),
					'default' => true,
				],
				[
					'id'      => 'wc_related',
					'type'    => 'switch',
					'title'   => esc_html( 'Related Products' ),
					'on'      => esc_html( 'Show' ),
					'off'     => esc_html( 'Hide' ),
					'default' => true,
				],
				[
					'id'      => 'wc_description',
					'type'    => 'switch',
					'title'   => esc_html( 'Description Tab' ),
					'on'      => esc_html( 'Show' ),
					'off'     => esc_html( 'Hide' ),
					'default' => true,
				],
				[
					'id'      => 'wc_reviews',
					'type'    => 'switch',
					'title'   => esc_html( 'Reviews Tab' ),
					'on'      => esc_html( 'Show' ),
					'off'     => esc_html( 'Hide' ),
					'default' => true,
				],
				[
					'id'      => 'wc_additional_info',
					'type'    => 'switch',
					'title'   => esc_html( 'Additional Information Tab' ),
					'on'      => esc_html( 'Show' ),
					'off'     => esc_html( 'Hide' ),
					'default' => true,
				],
				[
					'id'     => 'wc_sec_cart',
					'type'   => 'section',
					'title'  => esc_html( 'Cart Page' ),
					'indent' => true,
				],
				[
					'id'      => 'wc_cross_sell',
					'type'    => 'switch',
					'title'   => esc_html( 'Cross Sell Products' ),
					'on'      => esc_html( 'Show' ),
					'off'     => esc_html( 'Hide' ),
					'default' => true,
				],
			],
		]
	);
}


// -> END Fields