<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.6
 */

$thumb_size = 'rdtheme-size8';

$args = array(
    'post_type'      => 'ac_testimonial',
    'posts_per_page' => $data['item_no'],
    'orderby' => $data['orderby'],
    'order'   => $data['sortby'],
);

if ( !empty( $data['cat'] ) ) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'ac_testimonial_category',
            'field' => 'term_id',
            'terms' => $data['cat'],
        )
    );
}

$query = new WP_Query( $args );

global $wp_query;
$wp_query = NULL;
$wp_query = $query;

?>
<div class="rt-vc-testimonial-4 owl-wrap">
    <div class="owl-theme owl-carousel rt-owl-carousel" data-carousel-options="<?php echo esc_attr( $data['owl_data'] );?>">
        <?php if ( have_posts() ): ?>
            <?php while ( have_posts() ) : the_post();?>
                <?php
                $id = get_the_ID();
                $designation = get_post_meta( $id, 'ac_testimonial_designation', true );
		        $top_title = get_post_meta( $id, 'ac_top_title', true );
                $content = get_the_content();
                //content trim words
                if( $data['length'] > 0 ){
	                $content = wp_trim_words( $content, $data['length'] );
                }


                ?>
                <div class="rtin-item">
                    <div class="rt-rating">
                        <?php
                        $rating = get_post_meta( $id, 'ac_testimonial_rating', true );
                        for ( $i = 1; $i <= 5; $i++ ) {
                            if ( $i <= $rating ) {
                                echo '<i class="fas fa-star"></i>';
                            } else {
                                echo '<i class="far fa-star"></i>';
                            }
                        }
                        ?>
                    </div>
                    <div class="rtin-content testimonial-content">
	                    <?php if( !empty( $top_title ) ): ?>
                            <h3 class="rt-top-title"><?php echo esc_html( $top_title ); ?></h3>
	                    <?php endif; ?>
                        <?php echo esc_html( $content ); ?>
                    </div>
                    <div class="rtin-content-area">
	                    <?php
                            if ( has_post_thumbnail() ){
                                the_post_thumbnail( $thumb_size ,  array( 'class' => 'img-circle' )  );
                            }
	                    ?>
                        <div class="title-designation">
                            <h3 class="testimonial-title"><?php the_title(); ?></h3>
	                        <?php if( !empty( $designation ) ): ?>
                                <div class="rtin-designation testimonial-designation"><?php echo esc_html( $designation ); ?></div>
	                        <?php endif; ?>
                        </div>
                    </div>

                </div>
            <?php endwhile; ?>
        <?php else:?>
            <?php esc_html_e( 'No Testimonial Found' , 'eikra-core' ); ?>
        <?php endif; ?>
        <?php wp_reset_query();?>
    </div>
    <div class="owl-custom-nav">
        <div class="owl-prev">
            <svg width="19" height="14" viewBox="0 0 19 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M17.9429 6.7998H0.800014M0.800014 6.7998L6.80001 0.799805M0.800014 6.7998L6.80001 12.7998" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
        </div>
        <div class="owl-next">
            <svg width="19" height="14" viewBox="0 0 19 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M0.800049 6.7998H17.9429 M17.9429 6.7998L11.9429 0.799805 M17.9429 6.7998L11.9429 12.7998" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
        </div>
    </div>
    <div class="rt-qoute-icon">
        <svg width="144" height="91" viewBox="0 0 144 91" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd" d="M49.067 58.1628C48.3758 64.594 46.5326 69.7289 43.3234 74.2822C39.0199 80.3561 31.8034 86.0312 19.872 92.0635C19.1066 92.4033 18.4175 92.8966 17.8466 93.5134C17.2757 94.1303 16.8349 94.8579 16.551 95.652C16.267 96.4462 16.1459 97.2903 16.1948 98.1331C16.2438 98.976 16.4618 99.8 16.8358 100.555C17.2097 101.31 17.7317 101.981 18.3701 102.526C19.0085 103.071 19.7499 103.48 20.5495 103.727C21.349 103.974 22.1899 104.055 23.0212 103.964C23.8524 103.873 24.6567 103.612 25.3851 103.197C38.1394 96.7663 47.3801 89.9779 53.3623 81.5111C59.4597 72.903 61.7143 63.2064 61.7143 51.9311L61.7143 14.5407C61.7143 10.6843 60.1971 6.98579 57.4966 4.25888C54.7961 1.53196 51.1334 0 47.3143 0L14.4 0C10.5809 0 6.91819 1.53196 4.21766 4.25888C1.51714 6.98579 0 10.6843 0 14.5407L0 43.6221C0 51.6486 6.4512 58.1628 14.4 58.1628L49.067 58.1628ZM131.353 58.1628C130.661 64.594 128.818 69.7289 125.609 74.2822C121.306 80.3561 114.089 86.0312 102.158 92.0635C101.392 92.4033 100.703 92.8966 100.132 93.5134C99.5614 94.1303 99.1206 94.8579 98.8367 95.652C98.5527 96.4462 98.4316 97.2903 98.4805 98.1331C98.5295 98.976 98.7476 99.8 99.1215 100.555C99.4954 101.31 100.017 101.981 100.656 102.526C101.294 103.071 102.036 103.48 102.835 103.727C103.635 103.974 104.476 104.055 105.307 103.964C106.138 103.873 106.942 103.612 107.671 103.197C120.425 96.7663 129.666 89.9779 135.648 81.5111C141.745 72.903 144 63.2064 144 51.9311V14.5407C144 10.6843 142.483 6.98579 139.782 4.25888C137.082 1.53196 133.419 0 129.6 0L96.6857 0C92.8666 0 89.2039 1.53196 86.5034 4.25888C83.8028 6.98579 82.2857 10.6843 82.2857 14.5407V43.6221C82.2857 51.6486 88.7369 58.1628 96.6857 58.1628H131.353Z" fill="#F8F8F8"/>
        </svg>
    </div>
</div>