<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Utils;
if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Move_Shape extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Move Shape', 'eikra-core' );
		$this->rt_base = 'rt-move-shape';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){

		$fields = array(

			// ===========================
			// Section: General
			// ===========================
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_general',
				'label' => esc_html__( 'General', 'eikra-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			),

			array(
				'type'    => \Elementor\Controls_Manager::SELECT,
				'id'      => 'layout',
				'label'   => __( 'Moving Shape Style', 'eikra-core' ),
				'default' => 'moving-style1',
				'options' => array(
					'moving-style1' => __( 'Style 01', 'eikra-core' ),
				),
			),

			array(
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'id'      => 'image_shape',
				'label'   => esc_html__( 'Shape Images', 'eikra-core' ),
				'default' => array(
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				),
			),

			array(
				'type'    => \Elementor\Controls_Manager::SELECT,
				'id'      => 'icon_type',
				'label'   => __( 'Icon Type', 'eikra-core' ),
				'default' => 'icon',
				'options' => array(
					'icon'  => __( 'Icon', 'eikra-core' ),
					'image' => __( 'Image', 'eikra-core' ),
				),
			),

			array(
				'type'             => \Elementor\Controls_Manager::ICONS,
				'id'               => 'info_icon',
				'label'            => __( 'Choose Icon', 'eikra-core' ),
				'fa4compatibility' => 'icon',
				'default'          => array(
					'value'   => 'fas fa-home',
					'library' => 'fa-solid',
				),
				'condition'        => array(
					'icon_type' => array( 'icon' ),
				),
			),

			array(
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'id'        => 'image_icon',
				'label'     => __( 'Choose Image', 'eikra-core' ),
				'default'   => array(
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				),
				'condition' => array(
					'icon_type' => array( 'image' ),
				),
			),

			array(
				'type'        => \Elementor\Controls_Manager::TEXT,
				'id'          => 'sec_url_id',
				'label'       => esc_html__( 'Add Section URL ID', 'eikra-core' ),
				'label_block' => true,
			),

			array(
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'id'        => 'animation',
				'label'     => __( 'Animation', 'eikra-core' ),
				'label_on'  => __( 'On', 'eikra-core' ),
				'label_off' => __( 'Off', 'eikra-core' ),
				'default'   => 'yes',
			),

			array(
				'mode'       => 'responsive',
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'id'         => 'wrap_height',
				'label'      => __( 'Wrapper Height', 'eikra-core' ),
				'size_units' => array( 'px', '%', 'vh' ),
				'range'      => array(
					'px' => array( 'min' => 0, 'max' => 1000, 'step' => 1 ),
					'%'  => array( 'min' => 0, 'max' => 100 ),
					'vh' => array( 'min' => 0, 'max' => 100, 'step' => 1 ),
				),
				'selectors'  => array(
					'{{WRAPPER}} .about-round-box' => 'height: {{SIZE}}{{UNIT}};',
				),
			),

			array(
				'mode'       => 'responsive',
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'id'         => 'wrap_width',
				'label'      => __( 'Wrapper Width', 'eikra-core' ),
				'size_units' => array( 'px', '%', 'vh' ),
				'range'      => array(
					'px' => array( 'min' => 0, 'max' => 1000, 'step' => 1 ),
					'%'  => array( 'min' => 0, 'max' => 100 ),
					'vh' => array( 'min' => 0, 'max' => 100, 'step' => 1 ),
				),
				'selectors'  => array(
					'{{WRAPPER}} .about-round-box' => 'width: {{SIZE}}{{UNIT}};',
				),
			),

			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Border::get_type(),
				'name'     => 'wrap_border',
				'selector' => '{{WRAPPER}} .moving-shape-wrap .about-round-box',
			),

			array(
				'mode'       => 'responsive',
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'id'         => 'wrap_radius',
				'label'      => __( 'Wrapper Radius', 'eikra-core' ),
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .moving-shape-wrap .about-round-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				),
			),

			array(
				'mode'          => 'group',
				'type'          => \Elementor\Group_Control_Background::get_type(),
				'name'          => 'wrap_background',
				'label'         => __( 'Wrapper Background Style', 'eikra-core' ),
				'types'         => array( 'classic', 'gradient' ),
				'fields_options' => array(
					'background' => array(
						'label' => esc_html__( 'Wrapper Background Style', 'eikra-core' ),
					),
				),
				'selector' => '{{WRAPPER}} .moving-shape-wrap .about-round-box',
			),

			array(
				'type'    => \Elementor\Controls_Manager::SELECT2,
				'id'      => 'position',
				'label'   => esc_html__( 'Position', 'eikra-core' ),
				'options' => array(
					'relative' => esc_html__( 'Relative', 'eikra-core' ),
					'absolute' => esc_html__( 'Absolute', 'eikra-core' ),
				),
				'default' => 'relative',
			),

			array(
				'type'    => \Elementor\Controls_Manager::NUMBER,
				'id'      => 'z_index',
				'label'   => esc_html__( 'Z-Index', 'eikra-core' ),
				'default' => 1,
			),

			// ... continue converting all other controls in the same format ...

			array(
				'mode' => 'section_end',
			),

			// ===========================
			// Section: Icon Style
			// ===========================
			array(
				'mode'  => 'section_start',
				'id'    => 'icon_style',
				'label' => esc_html__( 'Icon Style', 'eikra-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			),

			array(
				'type'      => \Elementor\Controls_Manager::COLOR,
				'id'        => 'icon_color',
				'label'     => __( 'Icon Color', 'eikra-core' ),
				'selectors' => array(
					'{{WRAPPER}} .moving-shape-wrap svg path' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .moving-shape-wrap .about-round-box .moving-shape-box i' => 'color: {{VALUE}}',
				),
			),

			array(
				'mode' => 'section_end',
			),
		);

		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		$template = 'view';
		// rt_template() echoes the template output directly. Do not return its result.
		$this->rt_template( $template, $data );
	}
}
