<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Utils;
if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Marquee_Slider extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Marquee Slider', 'eikra-core' );
		$this->rt_base = 'rt-marquee-slider';
		parent::__construct( $data, $args );
	}	

	public function rt_fields(){
		$repeater = new \Elementor\Repeater(); 
		
		$repeater->add_control(
			'title', [
				'type'  => Controls_Manager::TEXT,
				'label' => esc_html__( 'Title', 'eikra-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'image', [
				'type'    => Controls_Manager::MEDIA,
				'label'   => __( 'Image', 'eikra-core' ),
				'description' => __( 'Recommended image size is 160x160 px.<br/>You can upload SVG format as well, to get SVG images click here: <a target="_blank" href="https://www.flaticon.com/">flaticon.com</a>', 'eikra-core' ),
			]
		);
		$repeater->add_control(
			'url', [
				'type'  => Controls_Manager::URL,
				'label' => esc_html__( 'URL(optional)', 'eikra-core' ),
				'label_block' => true,
			]
		);
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'eikra-core' ),
			),	
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'marquee_direction',
				'label'   => esc_html__( 'Marquee', 'eikra-core' ),
				'options' => array(
					'marquee_left' => esc_html__( 'Left Direction' , 'eikra-core' ),
					'marquee_right' => esc_html__( 'Right Direction', 'eikra-core' ),
				),
				'default' => 'marquee_left',
			),
			array(
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'marquee_slide',
				'label'   => esc_html__( 'Add as many title as you want', 'eikra-core' ),
				'title_field' => '{{{ title }}}',
				'fields' => $repeater->get_controls(),
				'default' => array(
					['title' => 'First your free trial and enjoy 1 months of eikra for $2/month on select plans.', ],
					['title' => 'Next your pro enjoy 5 months of eikra for $10/month on select plans.', ],
					['title' => 'Previus your pro enjoy 10 months of eikra for $20/month on select plans.', ],
					['title' => 'Next your pro enjoy 12 months of eikra for $50/month on select plans.', ],
				),			
			),
			
			array(
				'type' => Controls_Manager::SELECT,
				'id'      => 'heading_size',
				'label'   => esc_html__( 'HTML Tag', 'eikra-core' ),
				'options' => array(
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
					'div' => 'div',
					'span' => 'span',
					'p' => 'p',
				),
				'default' => 'h3',
			),
			array(
				'mode' => 'section_end',
			),			
			// Title style
			array(
	            'mode'    => 'section_start',
	            'id'      => 'sec_title_style',
	            'label'   => esc_html__( 'Title Style', 'eikra-core' ),
	            'tab'     => Controls_Manager::TAB_STYLE,
	        ),
			array(
				'mode'     => 'group',
				'type'     => Group_Control_Typography::get_type(),
				'id'       => 'title_typo',
				'label'    => esc_html__( 'Title Typo', 'eikra-core' ),
				'selector' => '{{WRAPPER}} .rt-marquee-slider .rt-marquee-item .entry-title',
			),
			array(
				'type'    => Controls_Manager::COLOR,
			 	'id'      => 'title_color',				
				'label'   => esc_html__( 'Color', 'eikra-core' ),
				'selectors' => array(
					'{{WRAPPER}} .rt-marquee-slider .rt-marquee-item .entry-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-marquee-slider .rt-marquee-item .entry-title a' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
			 	'id'      => 'title_hover_color',				
				'label'   => esc_html__( 'Hover Color', 'eikra-core' ),
				'selectors' => array(
					'{{WRAPPER}} .rt-marquee-slider .rt-marquee-item .entry-title a:hover' => 'color: {{VALUE}}',
				),
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Text_Shadow::get_type(),
				'id'      => 'title_shadow',
				'label'   => esc_html__( 'Shadow', 'eikra-core' ),
				'selector' => '{{WRAPPER}} .rt-marquee-slider .rt-marquee-item .entry-title',
			),
			array(
				'mode' => 'section_end',
			),

			// Icon style
			array(
	            'mode'    => 'section_start',
	            'id'      => 'sec_icon_style',
	            'label'   => esc_html__( 'Icon Style', 'eikra-core' ),
	            'tab'     => Controls_Manager::TAB_STYLE,
	        ),
			/*Icon Start*/
			array(					 
				'type'    => Controls_Manager::CHOOSE,
				'options' => array(
				  'icon' => array(
					'title' => esc_html__( 'Left', 'eikra-core' ),
					'icon' => 'fa fa-smile',
				  ),
				  'image' => array(
					'title' => esc_html__( 'Center', 'eikra-core' ),
					'icon' => 'fa fa-image',
				  ),		     
				),
				'id'      => 'icontype',
				'label'   => esc_html__( 'Media Type', 'eikra-core' ),
				'default' => 'icon',
				'label_block' => false,
				'toggle' => false,
			),
			array(
				 'type'    => Controls_Manager::ICONS,
				 'id'      => 'icon_class',
				 'label'   => esc_html__( 'Icon', 'eikra-core' ),
				 'default' => array(
				   'value' => 'fas fa-asterisk',
				   'library' => 'fa-solid',
				),	
				   'condition'   => array('icontype' => array( 'icon' ) ),
			),	
			array(
				 'type'    => Controls_Manager::MEDIA,
				 'id'      => 'icon_image',
				 'label'   => esc_html__( 'Image', 'eikra-core' ),
				 'default' => array(
					 'url' => Utils::get_placeholder_image_src(),
				 ),
				 'description' => esc_html__( 'Recommended full image', 'eikra-core' ),
				 'condition'   => array('icontype' => array( 'image' ) ),
			),		
			/*Icon end*/
			array(
				'type'    => Controls_Manager::COLOR,
			 	'id'      => 'icon_color',				
				'label'   => esc_html__( 'Color', 'eikra-core' ),
				'selectors' => array(
					'{{WRAPPER}} .rt-marquee-slider .entry-title span' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-marquee-slider .entry-title path' => 'fill: {{VALUE}}',
				),
				'condition'   => array('icontype' => array( 'icon' ) ),
			),
	        array(
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'id'      => 'icon_typo',
				'label'   => esc_html__( 'Typo', 'eikra-core' ),
				'selector' => '{{WRAPPER}} .rt-marquee-slider .entry-title span',
				'condition'   => array('icontype' => array( 'icon' ) ),
			),
			array(
				'type'    => Controls_Manager::SLIDER,
				'id'      => 'icon_gap',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Icon Gap', 'eikra-core' ),
				'size_units' => array( '%', 'px' ),
				'range' => array(
					'%' => array(
						'min' => 1,
						'max' => 100,
					),
					'px' => array(
						'min' => 1,
						'max' => 500,
					),
				),
				'selectors' => array( 
					'{{WRAPPER}} .rt-marquee-slider .rt-marquee-item .entry-title span' => 'width: {{SIZE}}{{UNIT}};',
				),
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		$template = 'view';
		// rt_template() echoes the template output directly. Do not return its result.
		$this->rt_template( $template, $data );
	}
}
