<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$args = array(
    'role'   => LP_TEACHER_ROLE,
    'number' => $data['item_no'],
);

$orderby = $data['orderby'];

switch ( $orderby ) {
    case 'id_asc':
        $args['orderby'] = 'ID';
        $args['order']   = 'ASC';
        break;

    case 'id_dsc':
        $args['orderby'] = 'ID';
        $args['order']   = 'DESC';
        break;

    case 'display_name':
        $args['orderby'] = 'display_name';
        $args['order']   = 'ASC';
        break;

    case 'custom_order':
        $args['meta_query'] = array(
            'relation' => 'OR',
            'b' => array(
                'key' => 'rt_user_custom_order',
                'compare' => 'EXISTS',
            ),
            'a' => array(
                'key' => 'rt_user_custom_order',
                'compare' => 'NOT EXISTS',
            ),

        );
        //$this->user_custom_ordering();
        break;

    default:
        $args['orderby'] = 'ID';
        $args['order']   = 'DESC';
        break;
}

$query = new WP_User_Query( $args );

?>

<div class="rt-vc-instructor-slider-5 owl-wrap rt-owl-nav-1">
    <div class="owl-theme owl-carousel rt-owl-carousel" data-carousel-options="<?php echo esc_attr( $data['owl_data'] );?>">
        <?php if ( ! empty( $query->results ) ): ?>
            <?php foreach ( $query->results as $instructor ): ?>
                <?php
                $id = $instructor->ID;
                $user_meta = get_the_author_meta( 'rt_lp_instructor_info', $id );
		        $socials = isset( $user_meta['socials'] ) ? $user_meta['socials'] : array();
		        $socials = array_filter( $socials );
		        $socials_fields = RDTheme_Helper::instructor_socials();
                ?>
                <div class="rtin-item">
	                <?php if ( !empty( $socials ) ) : ?>
                    <div class="rt-social-share">
                        <div class="rt-wrap-icon">
                            <svg width="15" height="17" viewBox="0 0 15 17" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M4.9425 9.3825L10.065 12.3675M10.0575 4.1325L4.9425 7.1175M14.25 3C14.25 4.24264 13.2426 5.25 12 5.25C10.7574 5.25 9.75 4.24264 9.75 3C9.75 1.75736 10.7574 0.75 12 0.75C13.2426 0.75 14.25 1.75736 14.25 3ZM5.25 8.25C5.25 9.49264 4.24264 10.5 3 10.5C1.75736 10.5 0.75 9.49264 0.75 8.25C0.75 7.00736 1.75736 6 3 6C4.24264 6 5.25 7.00736 5.25 8.25ZM14.25 13.5C14.25 14.7426 13.2426 15.75 12 15.75C10.7574 15.75 9.75 14.7426 9.75 13.5C9.75 12.2574 10.7574 11.25 12 11.25C13.2426 11.25 14.25 12.2574 14.25 13.5Z" stroke="#444444" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <ul class="rtin-social">
			                <?php foreach ( $socials as $key => $value ): ?>
                                <li><a href="<?php echo esc_url(  $value ); ?>" target="_blank"><i class="<?php echo esc_attr( $socials_fields[$key]['icon'] ); ?>"></i></a></li>
			                <?php endforeach; ?>
                        </ul>
                    </div>
	                <?php endif; ?>
                    <div class="rtin-img">
                        <a href="<?php echo esc_url( learn_press_user_profile_link( $id ) ); ?>"><?php echo get_avatar( $id , 512 ); ?></a>
                    </div>
                    <div class="rtin-content">
                        <h3 class="rtin-title"><a href="<?php echo esc_url( learn_press_user_profile_link( $id ) ); ?>"><?php echo esc_html( $instructor->display_name ); ?></a></h3>
                        <?php if ( !empty( $user_meta['designation'] ) ) : ?>
                            <div class="rtin-designation"><?php echo wp_kses_post( $user_meta['designation'] ); ?></div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <?php esc_html_e( 'No Instructors Found' , 'eikra-core' ); ?>
        <?php endif; ?>
        <?php wp_reset_query(); ?>
    </div>
</div>