<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$thumb_size = 'rdtheme-size6';

if ( ! empty( $data['category'] ) ) {
	$blog_permalink = get_category_link( $data['category'] );
} else {
	$blog_page      = get_option( 'page_for_posts' );
	$blog_permalink = $blog_page ? get_permalink( $blog_page ) : home_url( '/' );
}

$args = [
	'posts_per_page'      => $data['item_no'],
	'ignore_sticky_posts' => 1,
	'orderby'       => $data['orderby'],
	'order'         => $data['order'],
];

if ( ! empty( $data['category'] ) ) {
	$args['cat'] = $data['category'];
}
if ( $data['offset'] ) {
	$args['offset'] = $data['offset'];
}

if ( $data['exclude'] ) {
	$post_exclude         = explode( ',', $data['exclude'] );
	$args['post__not_in'] = $post_exclude;
}
$query = new WP_Query( $args );

global $wp_query;
$wp_query = null;
$wp_query = $query;

?>

<div class="rt-vc-posts">
    <?php if( $data['title'] ): ?>
    <h2 class="rt-vc-title-left rtin-post-title"><?php echo esc_html( $data['title'] ); ?></h2>
	<?php endif; ?>
    <?php if ( have_posts() ): ?>
        <div class="rtin-item row p-0">
			<?php while ( have_posts() ) : the_post(); ?>
				<?php
				$content = RDTheme_Helper::get_current_post_content();
				$content = wp_trim_words( $content, $data['content_limit'] );
				?>
                <div class="col-lg-4 col-md-4 col-sm-6 col-xs-6">
                    <div class="rt-blog-inner rt-blog-style3">
                        <div class="media-left rtin-img">
                            <a href="<?php the_permalink(); ?>">
                                <?php
                                if ( has_post_thumbnail() ) {
                                    the_post_thumbnail( $thumb_size );
                                } else {
                                    if ( ! empty( RDTheme::$options['no_preview_image']['id'] ) ) {
                                        echo wp_get_attachment_image( RDTheme::$options['no_preview_image']['id'], $thumb_size );
                                    } else {
                                        echo '<img class="media-object wp-post-image" src="' . RDTHEME_IMG_URL . 'noimage_150x100.jpg" alt="' . get_the_title() . '">';
                                    }
                                }
                                ?>
                            </a>
                        </div>
                        <div class="media-body rtin-content-area">
                            <div class="rt-date-inner">
                                <div class="rtin-date">
                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M10.6611 0.549805V3.34983M4.43887 0.549805V3.34983M0.549988 6.14972H14.55M2.10554 1.94968H12.9944C13.8535 1.94968 14.55 2.57649 14.55 3.3497V13.1498C14.55 13.923 13.8535 14.5498 12.9944 14.5498H2.10554C1.24643 14.5498 0.549988 13.923 0.549988 13.1498V3.3497C0.549988 2.57649 1.24643 1.94968 2.10554 1.94968Z" stroke="currentColor" stroke-width="1.1" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                    <?php the_time( get_option( 'date_format' ) ); ?>
                                </div>
                                <div class="rtin-category">
                                    <svg width="12" height="14" viewBox="0 0 12 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M10.4667 13.2998L5.50832 9.75814L0.549988 13.2998V1.96647
                                              C0.549988 1.59075 0.699243 1.23041 0.96492 0.964737
                                              C1.2306 0.69906 1.59093 0.549805 1.96665 0.549805
                                              H9.04999 C9.42571 0.549805 9.78605 0.69906 10.0517 0.964737
                                              C10.3174 1.23041 10.4667 1.59075 10.4667 1.96647
                                              V13.2998Z"
                                              stroke="currentColor"
                                              stroke-width="1.1"
                                              stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                    </svg>

                                    <?php
                                        $categories = get_the_category();
                                        if ( ! empty( $categories ) ) {
                                            $category = $categories[0];
                                            echo '<a href="' . esc_url( get_category_link( $category->term_id ) ) . '" alt="' .
                                                 esc_attr( sprintf( __( 'View all posts in %s', 'eikra-core' ), $category->name ) ) .
                                                 '">' . esc_html( $category->name ) . '</a>';
                                        }
                                    ?>
                                </div>
                            </div>
                            <h3 class="rtin-blog-post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                            <p class="rtin-content"><?php echo wp_kses_post( $content ); ?></p>
                            <div class="rt-in-read-more">
                                <a href="<?php the_permalink(); ?>">
                                    <?php echo esc_html( $data['read_more_text'] ); ?>
                                    <svg width="17" height="14" viewBox="0 0 17 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M0.857147 6.85693H15.4286
                                              M15.4286 6.85693L9.42858 0.856934
                                              M15.4286 6.85693L9.42858 12.8569"
                                              stroke="currentColor"
                                              stroke-width="1.71429"
                                              stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                    </svg>

                                </a>
                            </div>
                        </div>
                    </div>
                </div>
			<?php endwhile; ?>
        </div>
		<?php if ( $data['btn_display'] == 'yes' ): ?>
            <div class="rtin-btn">
                <a href="<?php echo esc_url( $blog_permalink ); ?>" class="rdtheme-button-6"><?php echo esc_html( $data['btn_text'] ); ?></a>
            </div>
		<?php endif; ?>
	<?php else: ?>
		<?php esc_html_e( 'No posts found', 'eikra-core' ); ?>
	<?php endif; ?>
	<?php wp_reset_query(); ?>
</div>
